/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;

@Rule(key="S1181")
public class CatchOfThrowableOrErrorCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_THROWABLE = "java.lang.Throwable";
    private final TryBlockVisitor tryBlockVisitor = new TryBlockVisitor();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TRY_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        TryStatementTree tryStatement = (TryStatementTree)tree;
        tryStatement.block().accept(this.tryBlockVisitor);
        if (this.tryBlockVisitor.containsExplicitThrowable || this.tryBlockVisitor.containsUnresolvableCall) {
            return;
        }
        for (CatchTree catchTree : tryStatement.catches()) {
            TypeTree typeTree = catchTree.parameter().type();
            if (typeTree.is(Tree.Kind.UNION_TYPE)) {
                for (TypeTree alternativeTypeTree : ((UnionTypeTree)typeTree).typeAlternatives()) {
                    this.checkType(alternativeTypeTree, catchTree);
                }
                continue;
            }
            this.checkType(typeTree, catchTree);
        }
    }

    private void checkType(TypeTree typeTree, CatchTree catchTree) {
        Type type = typeTree.symbolType();
        if (type.is("java.lang.Error")) {
            this.insertIssue(typeTree, type);
        } else if (type.is(JAVA_LANG_THROWABLE)) {
            ReThrowVisitor visitor = new ReThrowVisitor(catchTree.parameter().symbol());
            catchTree.block().accept(visitor);
            if (!visitor.foundRethrow) {
                this.insertIssue(typeTree, type);
            }
        }
    }

    private void insertIssue(TypeTree typeTree, Type type) {
        this.reportIssue(typeTree, "Catch Exception instead of " + type.name() + ".");
    }

    private static class TryBlockVisitor
    extends BaseTreeVisitor {
        private boolean containsExplicitThrowable;
        private boolean containsUnresolvableCall;

        private TryBlockVisitor() {
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree tree) {
            this.checkIfThrowThrowable(tree.symbol());
            super.visitMethodInvocation(tree);
        }

        @Override
        public void visitNewClass(NewClassTree tree) {
            this.checkIfThrowThrowable(tree.constructorSymbol());
            super.visitNewClass(tree);
        }

        private void checkIfThrowThrowable(Symbol symbol) {
            if (this.containsExplicitThrowable || this.containsUnresolvableCall) {
                return;
            }
            if (symbol.isUnknown()) {
                this.containsUnresolvableCall = true;
                return;
            }
            if (symbol.isMethodSymbol()) {
                for (Type type : ((Symbol.MethodSymbol)symbol).thrownTypes()) {
                    if (!type.is(CatchOfThrowableOrErrorCheck.JAVA_LANG_THROWABLE)) continue;
                    this.containsExplicitThrowable = true;
                    return;
                }
            }
        }
    }

    private static class ReThrowVisitor
    extends BaseTreeVisitor {
        private static final String JAVA_LANG_CLASS = "java.lang.Class";
        private static final MethodMatchers MATCHERS = MethodMatchers.create().ofTypes("com.google.common.io.Closer").names("rethrow").addParametersMatcher("java.lang.Throwable").addParametersMatcher("java.lang.Throwable", "java.lang.Class").addParametersMatcher("java.lang.Throwable", "java.lang.Class", "java.lang.Class").build();
        private boolean foundRethrow = false;
        private final Symbol exceptionSymbol;

        public ReThrowVisitor(Symbol exceptionSymbol) {
            this.exceptionSymbol = exceptionSymbol;
        }

        @Override
        public void visitThrowStatement(ThrowStatementTree tree) {
            MethodInvocationTree mit;
            ExpressionTree expression = tree.expression();
            if (expression.is(Tree.Kind.METHOD_INVOCATION) && ((mit = (MethodInvocationTree)expression).symbol().isUnknown() || this.isGuavaCloserRethrow(mit))) {
                this.foundRethrow = true;
            }
        }

        private boolean isGuavaCloserRethrow(MethodInvocationTree mit) {
            if (!MATCHERS.matches(mit)) {
                return false;
            }
            ExpressionTree firstArgument = (ExpressionTree)mit.arguments().get(0);
            return firstArgument.is(Tree.Kind.IDENTIFIER) && this.exceptionSymbol.equals(((IdentifierTree)firstArgument).symbol());
        }
    }
}

