/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.LongConsumer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.DeDuplicatingTokenFilter;
import org.apache.lucene.analysis.miscellaneous.DuplicateByteSequenceSpotter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.MapStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.SignificanceLookup;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTextAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.search.profile.Timer;

public class SignificantTextAggregatorFactory
extends AggregatorFactory {
    private static final int MEMORY_GROWTH_REPORTING_INTERVAL_BYTES = 5000;
    private final IncludeExclude includeExclude;
    private final MappedFieldType fieldType;
    private final String[] sourceFieldNames;
    private final QueryBuilder backgroundFilter;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final SignificanceHeuristic significanceHeuristic;
    private final boolean filterDuplicateText;

    public SignificantTextAggregatorFactory(String name, IncludeExclude includeExclude, QueryBuilder backgroundFilter, TermsAggregator.BucketCountThresholds bucketCountThresholds, SignificanceHeuristic significanceHeuristic, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, String fieldName, String[] sourceFieldNames, boolean filterDuplicateText, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metadata);
        this.fieldType = context.getFieldType(fieldName);
        if (this.fieldType != null) {
            String[] stringArray;
            if (!SignificantTextAggregatorFactory.supportsAgg(this.fieldType)) {
                throw new IllegalArgumentException("Field [" + this.fieldType.name() + "] has no analyzer, but SignificantText requires an analyzed field");
            }
            String indexedFieldName = this.fieldType.name();
            if (sourceFieldNames == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = indexedFieldName;
            } else {
                stringArray = sourceFieldNames;
            }
            this.sourceFieldNames = stringArray;
        } else {
            this.sourceFieldNames = new String[0];
        }
        this.includeExclude = includeExclude;
        this.backgroundFilter = backgroundFilter;
        this.filterDuplicateText = filterDuplicateText;
        this.bucketCountThresholds = bucketCountThresholds;
        this.significanceHeuristic = significanceHeuristic;
    }

    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedSignificantTerms aggregation = new UnmappedSignificantTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), metadata);
        return new NonCollectingAggregator(this.name, this.context, parent, this.factories, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    private static boolean supportsAgg(MappedFieldType ft) {
        return ft.getTextSearchInfo() != TextSearchInfo.NONE && ft.getTextSearchInfo() != TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (this.fieldType == null) {
            return this.createUnmapped(parent, metadata);
        }
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (bucketCountThresholds.getShardSize() == SignificantTextAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(2 * BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        IncludeExclude.StringFilter incExcFilter = this.includeExclude == null ? null : this.includeExclude.convertToStringFilter(DocValueFormat.RAW);
        SignificanceLookup lookup = new SignificanceLookup(this.context, this.fieldType, DocValueFormat.RAW, this.backgroundFilter);
        MapStringTermsAggregator.CollectorSource collectorSource = this.createCollectorSource();
        boolean success = false;
        try {
            MapStringTermsAggregator mapStringTermsAggregator = new MapStringTermsAggregator(this.name, this.factories, collectorSource, a -> {
                MapStringTermsAggregator mapStringTermsAggregator = a;
                Objects.requireNonNull(mapStringTermsAggregator);
                return mapStringTermsAggregator.new MapStringTermsAggregator.SignificantTermsResults(lookup, this.significanceHeuristic, cardinality);
            }, null, DocValueFormat.RAW, bucketCountThresholds, incExcFilter, this.context, parent, Aggregator.SubAggCollectionMode.BREADTH_FIRST, false, cardinality, metadata);
            success = true;
            MapStringTermsAggregator mapStringTermsAggregator2 = mapStringTermsAggregator;
            return mapStringTermsAggregator2;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable)collectorSource);
            }
        }
    }

    private MapStringTermsAggregator.CollectorSource createCollectorSource() {
        Analyzer analyzer = this.context.getIndexAnalyzer(f -> {
            throw new IllegalArgumentException("No analyzer configured for field " + f);
        });
        if (this.context.profiling()) {
            return new ProfilingSignificantTextCollectorSource(this.context.lookup().source(), this.context.bigArrays(), this.fieldType, analyzer, this.sourceFieldNames, this.filterDuplicateText);
        }
        return new SignificantTextCollectorSource(this.context.lookup().source(), this.context.bigArrays(), this.fieldType, analyzer, this.sourceFieldNames, this.filterDuplicateText);
    }

    private static class ProfilingSignificantTextCollectorSource
    extends SignificantTextCollectorSource {
        private final Timer extract = new Timer();
        private final Timer collectAnalyzed = new Timer();
        private long valuesFetched;
        private long charsFetched;

        private ProfilingSignificantTextCollectorSource(SourceLookup sourceLookup, BigArrays bigArrays, MappedFieldType fieldType, Analyzer analyzer, String[] sourceFieldNames, boolean filterDuplicateText) {
            super(sourceLookup, bigArrays, fieldType, analyzer, sourceFieldNames, filterDuplicateText);
        }

        @Override
        protected void processTokenStream(IncludeExclude.StringFilter includeExclude, int doc, long owningBucketOrd, String text, TokenStream ts, BytesRefHash inDocTerms, DuplicateByteSequenceSpotter spotter, LongConsumer addRequestCircuitBreakerBytes, LeafBucketCollector sub, MapStringTermsAggregator.CollectConsumer consumer) throws IOException {
            ++this.valuesFetched;
            this.charsFetched += (long)text.length();
            super.processTokenStream(includeExclude, doc, owningBucketOrd, text, ts, inDocTerms, spotter, addRequestCircuitBreakerBytes, sub, (subCollector, d, o, bytes) -> {
                this.collectAnalyzed.start();
                try {
                    consumer.accept(subCollector, d, o, bytes);
                }
                finally {
                    this.collectAnalyzed.stop();
                }
            });
        }

        @Override
        protected List<Object> extractRawValues(String field) {
            this.extract.start();
            try {
                List<Object> list = super.extractRawValues(field);
                return list;
            }
            finally {
                this.extract.stop();
            }
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("extract_ns", this.extract.getApproximateTiming());
            add.accept("extract_count", this.extract.getCount());
            add.accept("collect_analyzed_ns", this.collectAnalyzed.getApproximateTiming());
            add.accept("collect_analyzed_count", this.collectAnalyzed.getCount());
            add.accept("values_fetched", this.valuesFetched);
            add.accept("chars_fetched", this.charsFetched);
        }
    }

    private static class SignificantTextCollectorSource
    implements MapStringTermsAggregator.CollectorSource {
        private final SourceLookup sourceLookup;
        private final BigArrays bigArrays;
        private final MappedFieldType fieldType;
        private final Analyzer analyzer;
        private final String[] sourceFieldNames;
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private ObjectArray<DuplicateByteSequenceSpotter> dupSequenceSpotters;

        SignificantTextCollectorSource(SourceLookup sourceLookup, BigArrays bigArrays, MappedFieldType fieldType, Analyzer analyzer, String[] sourceFieldNames, boolean filterDuplicateText) {
            this.sourceLookup = sourceLookup;
            this.bigArrays = bigArrays;
            this.fieldType = fieldType;
            this.analyzer = analyzer;
            this.sourceFieldNames = sourceFieldNames;
            this.dupSequenceSpotters = filterDuplicateText ? bigArrays.newObjectArray(1L) : null;
        }

        @Override
        public String describe() {
            return "analyze " + this.fieldType.name() + " from _source";
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public LeafBucketCollector getLeafCollector(final IncludeExclude.StringFilter includeExclude, final LeafReaderContext ctx, final LeafBucketCollector sub, final LongConsumer addRequestCircuitBreakerBytes, final MapStringTermsAggregator.CollectConsumer consumer) throws IOException {
            return new LeafBucketCollectorBase(sub, null){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (dupSequenceSpotters == null) {
                        this.collectFromSource(doc, owningBucketOrd, null);
                        return;
                    }
                    dupSequenceSpotters = bigArrays.grow(dupSequenceSpotters, owningBucketOrd + 1L);
                    DuplicateByteSequenceSpotter spotter = (DuplicateByteSequenceSpotter)dupSequenceSpotters.get(owningBucketOrd);
                    if (spotter == null) {
                        spotter = new DuplicateByteSequenceSpotter();
                        dupSequenceSpotters.set(owningBucketOrd, spotter);
                    }
                    this.collectFromSource(doc, owningBucketOrd, spotter);
                    spotter.startNewSequence();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void collectFromSource(int doc, long owningBucketOrd, DuplicateByteSequenceSpotter spotter) throws IOException {
                    sourceLookup.setSegmentAndDocument(ctx, doc);
                    BytesRefHash inDocTerms = new BytesRefHash(256L, bigArrays);
                    try {
                        for (String sourceField : sourceFieldNames) {
                            Iterator itr = this.extractRawValues(sourceField).stream().map(obj -> {
                                if (obj == null) {
                                    return null;
                                }
                                if (obj instanceof BytesRef) {
                                    return fieldType.valueForDisplay(obj).toString();
                                }
                                return obj.toString();
                            }).iterator();
                            while (itr.hasNext()) {
                                String text = (String)itr.next();
                                TokenStream ts = analyzer.tokenStream(fieldType.name(), text);
                                this.processTokenStream(includeExclude, doc, owningBucketOrd, text, ts, inDocTerms, spotter, addRequestCircuitBreakerBytes, sub, consumer);
                            }
                        }
                    }
                    finally {
                        Releasables.close((Releasable)inDocTerms);
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processTokenStream(IncludeExclude.StringFilter includeExclude, int doc, long owningBucketOrd, String text, TokenStream ts, BytesRefHash inDocTerms, DuplicateByteSequenceSpotter spotter, LongConsumer addRequestCircuitBreakerBytes, LeafBucketCollector sub, MapStringTermsAggregator.CollectConsumer consumer) throws IOException {
            long growth;
            long lastTrieSize = 0L;
            if (spotter != null) {
                lastTrieSize = spotter.getEstimatedSizeInBytes();
                ts = new DeDuplicatingTokenFilter((TokenStream)ts, spotter);
            }
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            try {
                while (ts.incrementToken()) {
                    long newTrieSize;
                    long growth2;
                    if (spotter != null && (growth2 = (newTrieSize = spotter.getEstimatedSizeInBytes()) - lastTrieSize) > 5000L) {
                        addRequestCircuitBreakerBytes.accept(growth2);
                        lastTrieSize = newTrieSize;
                    }
                    this.scratch.clear();
                    this.scratch.copyChars((CharSequence)termAtt);
                    BytesRef bytes = this.scratch.get();
                    if (includeExclude != null && !includeExclude.accept(bytes) || inDocTerms.add(bytes) < 0L) continue;
                    consumer.accept(sub, doc, owningBucketOrd, bytes);
                }
            }
            finally {
                ts.close();
            }
            if (spotter != null && (growth = spotter.getEstimatedSizeInBytes() - lastTrieSize) > 0L) {
                addRequestCircuitBreakerBytes.accept(growth);
            }
        }

        protected List<Object> extractRawValues(String field) {
            return this.sourceLookup.extractRawValues(field);
        }

        public void close() {
            Releasables.close(this.dupSequenceSpotters);
        }
    }
}

