/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.stats.AnalysisStats;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.action.admin.cluster.stats.MappingStats;
import org.elasticsearch.action.admin.cluster.stats.VersionStats;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CancellableSingleObjectCache;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.seqno.RetentionLeaseStats;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;

public class TransportClusterStatsAction
extends TransportNodesAction<ClusterStatsRequest, ClusterStatsResponse, ClusterStatsNodeRequest, ClusterStatsNodeResponse> {
    private static final CommonStatsFlags SHARD_STATS_FLAGS = new CommonStatsFlags(CommonStatsFlags.Flag.Docs, CommonStatsFlags.Flag.Store, CommonStatsFlags.Flag.FieldData, CommonStatsFlags.Flag.QueryCache, CommonStatsFlags.Flag.Completion, CommonStatsFlags.Flag.Segments);
    private final NodeService nodeService;
    private final IndicesService indicesService;
    private final MetadataStatsCache<MappingStats> mappingStatsCache = new MetadataStatsCache<MappingStats>(MappingStats::of);
    private final MetadataStatsCache<AnalysisStats> analysisStatsCache = new MetadataStatsCache<AnalysisStats>(AnalysisStats::of);

    @Inject
    public TransportClusterStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, IndicesService indicesService, ActionFilters actionFilters) {
        super("cluster:monitor/stats", threadPool, clusterService, transportService, actionFilters, ClusterStatsRequest::new, ClusterStatsNodeRequest::new, "management", "management", ClusterStatsNodeResponse.class);
        this.nodeService = nodeService;
        this.indicesService = indicesService;
    }

    @Override
    protected void newResponseAsync(Task task, ClusterStatsRequest request, List<ClusterStatsNodeResponse> responses, List<FailedNodeException> failures, ActionListener<ClusterStatsResponse> listener) {
        assert (Transports.assertNotTransportThread("Computation of mapping/analysis stats runs expensive computations on mappings found in the cluster state that are too slow for a transport thread"));
        assert (Thread.currentThread().getName().contains("[management]")) : Thread.currentThread().getName();
        assert (task instanceof CancellableTask);
        CancellableTask cancellableTask = (CancellableTask)task;
        ClusterState state = this.clusterService.state();
        Metadata metadata = state.metadata();
        StepListener mappingStatsStep = new StepListener();
        StepListener analysisStatsStep = new StepListener();
        this.mappingStatsCache.get(metadata, cancellableTask::isCancelled, mappingStatsStep);
        this.analysisStatsCache.get(metadata, cancellableTask::isCancelled, analysisStatsStep);
        mappingStatsStep.whenComplete(mappingStats -> analysisStatsStep.whenComplete(analysisStats -> ActionListener.completeWith(listener, () -> new ClusterStatsResponse(System.currentTimeMillis(), metadata.clusterUUID(), this.clusterService.getClusterName(), responses, failures, (MappingStats)mappingStats, (AnalysisStats)analysisStats, VersionStats.of(metadata, responses))), listener::onFailure), listener::onFailure);
    }

    @Override
    protected ClusterStatsResponse newResponse(ClusterStatsRequest request, List<ClusterStatsNodeResponse> responses, List<FailedNodeException> failures) {
        assert (false);
        throw new UnsupportedOperationException("use newResponseAsync instead");
    }

    @Override
    protected ClusterStatsNodeRequest newNodeRequest(ClusterStatsRequest request) {
        return new ClusterStatsNodeRequest(request);
    }

    @Override
    protected ClusterStatsNodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new ClusterStatsNodeResponse(in);
    }

    @Override
    protected ClusterStatsNodeResponse nodeOperation(ClusterStatsNodeRequest nodeRequest) {
        assert (false);
        throw new UnsupportedOperationException("task is required");
    }

    @Override
    protected ClusterStatsNodeResponse nodeOperation(ClusterStatsNodeRequest nodeRequest, Task task) {
        assert (task instanceof CancellableTask);
        CancellableTask cancellableTask = (CancellableTask)task;
        NodeInfo nodeInfo = this.nodeService.info(true, true, false, true, false, true, false, true, false, false, false);
        NodeStats nodeStats = this.nodeService.stats(CommonStatsFlags.NONE, true, true, true, false, true, false, false, false, false, false, true, false, false, false);
        ArrayList<ShardStats> shardsStats = new ArrayList<ShardStats>();
        for (IndexService indexService : this.indicesService) {
            for (IndexShard indexShard : indexService) {
                RetentionLeaseStats retentionLeaseStats;
                SeqNoStats seqNoStats;
                CommitStats commitStats;
                cancellableTask.ensureNotCancelled();
                if (indexShard.routingEntry() == null || !indexShard.routingEntry().active()) continue;
                try {
                    commitStats = indexShard.commitStats();
                    seqNoStats = indexShard.seqNoStats();
                    retentionLeaseStats = indexShard.getRetentionLeaseStats();
                }
                catch (AlreadyClosedException e) {
                    commitStats = null;
                    seqNoStats = null;
                    retentionLeaseStats = null;
                }
                shardsStats.add(new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), new CommonStats(this.indicesService.getIndicesQueryCache(), indexShard, SHARD_STATS_FLAGS), commitStats, seqNoStats, retentionLeaseStats));
            }
        }
        ClusterHealthStatus clusterStatus = null;
        if (this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            clusterStatus = new ClusterStateHealth(this.clusterService.state()).getStatus();
        }
        return new ClusterStatsNodeResponse(nodeInfo.getNode(), clusterStatus, nodeInfo, nodeStats, shardsStats.toArray(new ShardStats[shardsStats.size()]));
    }

    private static class MetadataStatsCache<T>
    extends CancellableSingleObjectCache<Metadata, Long, T> {
        private final BiFunction<Metadata, Runnable, T> function;

        MetadataStatsCache(BiFunction<Metadata, Runnable, T> function) {
            this.function = function;
        }

        @Override
        protected void refresh(Metadata metadata, Runnable ensureNotCancelled, BooleanSupplier supersedeIfStale, ActionListener<T> listener) {
            ActionListener.completeWith(listener, () -> this.function.apply(metadata, ensureNotCancelled));
        }

        @Override
        protected Long getKey(Metadata indexMetadata) {
            return indexMetadata.version();
        }

        @Override
        protected boolean isFresh(Long currentKey, Long newKey) {
            return newKey <= currentKey;
        }
    }

    public static class ClusterStatsNodeRequest
    extends BaseNodeRequest {
        ClusterStatsRequest request;

        public ClusterStatsNodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new ClusterStatsRequest(in);
        }

        ClusterStatsNodeRequest(ClusterStatsRequest request) {
            this.request = request;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

