/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNSubstitutor;

public class SVNTranslatorInputStream
extends InputStream {
    private InputStream mySource;
    private ByteBuffer myTranslatedBuffer;
    private SVNSubstitutor mySubstitutor;
    private byte[] mySourceBuffer;

    public SVNTranslatorInputStream(InputStream source2, byte[] eols, boolean repair, Map keywords, boolean expand) {
        this.mySource = source2;
        this.mySubstitutor = new SVNSubstitutor(eols, repair, keywords, expand);
        this.myTranslatedBuffer = ByteBuffer.allocate(2048);
        this.mySourceBuffer = new byte[2048];
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int r = this.read(b);
        if (r <= 0) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        boolean isEOF = false;
        int available = this.myTranslatedBuffer.position();
        while (available < len) {
            int read = this.mySource.read(this.mySourceBuffer, 0, this.mySourceBuffer.length);
            if (read < 0) {
                isEOF = true;
                try {
                    this.myTranslatedBuffer = this.mySubstitutor.translateChunk(null, this.myTranslatedBuffer);
                    break;
                }
                catch (SVNException svne) {
                    IOExceptionWrapper wrappedException = new IOExceptionWrapper(svne);
                    throw wrappedException;
                }
            }
            try {
                this.myTranslatedBuffer = this.mySubstitutor.translateChunk(ByteBuffer.wrap(this.mySourceBuffer, 0, read), this.myTranslatedBuffer);
            }
            catch (SVNException svne) {
                IOExceptionWrapper wrappedException = new IOExceptionWrapper(svne);
                throw wrappedException;
            }
            available = this.myTranslatedBuffer.position();
        }
        this.myTranslatedBuffer.flip();
        len = Math.min(this.myTranslatedBuffer.remaining(), len);
        this.myTranslatedBuffer.get(b, off, len);
        this.myTranslatedBuffer.compact();
        if (isEOF && len == 0) {
            return -1;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.mySource.close();
    }
}

