/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.sonarqube.ws.FilenameUtils;
import org.sonarqube.ws.WsUtils;

public final class MediaTypes {
    public static final String DEFAULT = "application/octet-stream";
    public static final String HTML = "text/html";
    public static final String JAVASCRIPT = "application/javascript";
    public static final String JSON = "application/json";
    public static final String PROTOBUF = "application/x-protobuf";
    public static final String SVG = "image/svg+xml";
    public static final String TXT = "text/plain";
    public static final String XML = "application/xml";
    public static final String ZIP = "application/zip";
    private static final String BMP = "image/bmp";
    private static final String CSS = "text/css";
    private static final String CSV = "text/csv";
    private static final String DTD = "application/xml-dtd";
    private static final String GIF = "image/gif";
    private static final String ICO = "image/x-icon";
    private static final String JAR = "application/java-archive";
    private static final String JNLP = "application/jnlp";
    private static final String JPEG = "image/jpeg";
    private static final String JPG = "image/jpeg";
    private static final String PNG = "image/png";
    private static final String POSTSCRIPT = "application/postscript";
    private static final String PPT = "application/vnd.ms-powerpoint";
    private static final String RTF = "text/rtf";
    private static final String TAR = "application/x-tar";
    private static final String TIFF = "image/tiff";
    private static final String TGZ = "application/tgz";
    private static final String TSV = "text/tab-separated-values";
    private static final String XLS = "application/vnd.ms-excel";
    private static final String XSLT = "application/xslt+xml";
    private static final Map<String, String> MAP = new HashMap<String, String>(27);

    private MediaTypes() {
    }

    public static String getByFilename(String filename) {
        String extension = FilenameUtils.getExtension(filename);
        String mime = null;
        if (!WsUtils.isNullOrEmpty(extension)) {
            mime = MAP.get(extension.toLowerCase(Locale.ENGLISH));
        }
        return mime != null ? mime : DEFAULT;
    }

    static {
        MAP.put("js", JAVASCRIPT);
        MAP.put("json", JSON);
        MAP.put("zip", ZIP);
        MAP.put("tgz", TGZ);
        MAP.put("ps", POSTSCRIPT);
        MAP.put("jnlp", JNLP);
        MAP.put("jar", JAR);
        MAP.put("xls", XLS);
        MAP.put("ppt", PPT);
        MAP.put("tar", TAR);
        MAP.put("xml", XML);
        MAP.put("dtd", DTD);
        MAP.put("xslt", XSLT);
        MAP.put("bmp", BMP);
        MAP.put("gif", GIF);
        MAP.put("jpg", "image/jpeg");
        MAP.put("jpeg", "image/jpeg");
        MAP.put("tiff", TIFF);
        MAP.put("png", PNG);
        MAP.put("svg", SVG);
        MAP.put("ico", ICO);
        MAP.put("txt", TXT);
        MAP.put("csv", CSV);
        MAP.put("properties", TXT);
        MAP.put("rtf", RTF);
        MAP.put("html", HTML);
        MAP.put("css", CSS);
        MAP.put("tsv", TSV);
    }
}

