/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.branch;

import java.util.Collections;
import org.picocontainer.annotations.Nullable;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.ScannerProperties;
import org.sonar.scanner.scan.branch.ProjectPullRequests;
import org.sonar.scanner.scan.branch.ProjectPullRequestsLoader;

public class ProjectPullRequestsProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(ProjectPullRequestsProvider.class);
    private static final String LOG_MSG = "Load project pull requests";
    private ProjectPullRequests pullRequests = null;

    public ProjectPullRequests provide(@Nullable ProjectPullRequestsLoader loader, ScannerProperties scannerProperties) {
        if (this.pullRequests != null) {
            return this.pullRequests;
        }
        if (loader == null) {
            this.pullRequests = new ProjectPullRequests(Collections.emptyList());
            return this.pullRequests;
        }
        Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
        this.pullRequests = loader.load(scannerProperties.getProjectKey());
        profiler.stopInfo();
        return this.pullRequests;
    }
}

