/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository.language;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.picocontainer.Startable;
import org.sonar.api.resources.Languages;
import org.sonar.scanner.repository.language.Language;
import org.sonar.scanner.repository.language.LanguagesRepository;

@Immutable
public class DefaultLanguagesRepository
implements LanguagesRepository,
Startable {
    private Languages languages;

    public DefaultLanguagesRepository(Languages languages) {
        this.languages = languages;
    }

    @Override
    public void start() {
        if (this.languages.all().length == 0) {
            throw new IllegalStateException("No language plugins are installed.");
        }
    }

    @Override
    @CheckForNull
    public Language get(String languageKey) {
        org.sonar.api.resources.Language language = this.languages.get(languageKey);
        return language != null ? new Language(language.getKey(), language.getName(), language.publishAllFiles(), language.getFileSuffixes()) : null;
    }

    @Override
    public Collection<Language> all() {
        org.sonar.api.resources.Language[] all = this.languages.all();
        ArrayList<Language> result = new ArrayList<Language>(all.length);
        for (org.sonar.api.resources.Language language : all) {
            result.add(new Language(language.getKey(), language.getName(), language.publishAllFiles(), language.getFileSuffixes()));
        }
        return result;
    }

    @Override
    public void stop() {
    }
}

