/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.extension;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.extension.CoreExtension;
import org.sonar.core.extension.CoreExtensionRepository;
import org.sonar.core.extension.ServiceLoaderWrapper;
import org.sonar.core.util.stream.MoreCollectors;

public class CoreExtensionsLoader {
    private static final Logger LOG = Loggers.get(CoreExtensionsLoader.class);
    private final CoreExtensionRepository coreExtensionRepository;
    private final ServiceLoaderWrapper serviceLoaderWrapper;

    public CoreExtensionsLoader(CoreExtensionRepository coreExtensionRepository) {
        this(coreExtensionRepository, new ServiceLoaderWrapper());
    }

    CoreExtensionsLoader(CoreExtensionRepository coreExtensionRepository, ServiceLoaderWrapper serviceLoaderWrapper) {
        this.coreExtensionRepository = coreExtensionRepository;
        this.serviceLoaderWrapper = serviceLoaderWrapper;
    }

    public void load() {
        Set<CoreExtension> coreExtensions = this.serviceLoaderWrapper.load(this.getClass().getClassLoader());
        CoreExtensionsLoader.ensureNoDuplicateName(coreExtensions);
        this.coreExtensionRepository.setLoadedCoreExtensions(coreExtensions);
        if (!coreExtensions.isEmpty()) {
            LOG.info("Loaded core extensions: {}", (Object)coreExtensions.stream().map(CoreExtension::getName).collect(Collectors.joining(", ")));
        }
    }

    private static void ensureNoDuplicateName(Set<CoreExtension> coreExtensions) {
        Map<String, Long> nameCounts = coreExtensions.stream().map(CoreExtension::getName).collect(Collectors.groupingBy(t -> t, Collectors.counting()));
        Set duplicatedNames = nameCounts.entrySet().stream().filter(t -> (Long)t.getValue() > 1L).map(Map.Entry::getKey).collect(MoreCollectors.toSet());
        Preconditions.checkState(duplicatedNames.isEmpty(), "Multiple core extensions declare the following names: %s", (Object)duplicatedNames.stream().sorted().collect(Collectors.joining(", ")));
    }
}

