/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.extension;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.api.SonarRuntime;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.extension.CoreExtension;
import org.sonar.core.extension.CoreExtensionRepository;
import org.sonar.core.platform.ComponentContainer;

public abstract class CoreExtensionsInstaller {
    private static final Logger LOG = Loggers.get(CoreExtensionsInstaller.class);
    private final SonarRuntime sonarRuntime;
    private final CoreExtensionRepository coreExtensionRepository;
    private final Class<? extends Annotation> supportedAnnotationType;

    protected CoreExtensionsInstaller(SonarRuntime sonarRuntime, CoreExtensionRepository coreExtensionRepository, Class<? extends Annotation> supportedAnnotationType) {
        this.sonarRuntime = sonarRuntime;
        this.coreExtensionRepository = coreExtensionRepository;
        this.supportedAnnotationType = supportedAnnotationType;
    }

    public static Predicate<Object> noExtensionFilter() {
        return t -> true;
    }

    public static Predicate<Object> noAdditionalSideFilter() {
        return t -> true;
    }

    public void install(ComponentContainer container, Predicate<Object> extensionFilter, Predicate<Object> additionalSideFilter) {
        this.coreExtensionRepository.loadedCoreExtensions().forEach(coreExtension -> this.install(container, extensionFilter, additionalSideFilter, (CoreExtension)coreExtension));
    }

    private void install(ComponentContainer container, Predicate<Object> extensionFilter, Predicate<Object> additionalSideFilter, CoreExtension coreExtension) {
        String coreExtensionName = coreExtension.getName();
        try {
            this.addDeclaredExtensions(container, extensionFilter, additionalSideFilter, coreExtension);
            LOG.debug("Installed core extension: " + coreExtensionName);
            this.coreExtensionRepository.installed(coreExtension);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load core extension " + coreExtensionName, e);
        }
    }

    private void addDeclaredExtensions(ComponentContainer container, Predicate<Object> extensionFilter, Predicate<Object> additionalSideFilter, CoreExtension coreExtension) {
        ContextImpl context = new ContextImpl(container, extensionFilter, additionalSideFilter, coreExtension.getName());
        coreExtension.load(context);
    }

    private <T> boolean addSupportedExtension(ComponentContainer container, Predicate<Object> additionalSideFilter, String extensionCategory, T component) {
        if (this.hasSupportedAnnotation(component) && additionalSideFilter.test(component)) {
            container.addExtension(extensionCategory, component);
            return true;
        }
        return false;
    }

    private <T> boolean hasSupportedAnnotation(T component) {
        return AnnotationUtils.getAnnotation(component, this.supportedAnnotationType) != null;
    }

    private class ContextImpl
    implements CoreExtension.Context {
        private final ComponentContainer container;
        private final Predicate<Object> extensionFilter;
        private final Predicate<Object> additionalSideFilter;
        private final String extensionCategory;

        public ContextImpl(ComponentContainer container, Predicate<Object> extensionFilter, Predicate<Object> additionalSideFilter, String extensionCategory) {
            this.container = container;
            this.extensionFilter = extensionFilter;
            this.additionalSideFilter = additionalSideFilter;
            this.extensionCategory = extensionCategory;
        }

        @Override
        public SonarRuntime getRuntime() {
            return CoreExtensionsInstaller.this.sonarRuntime;
        }

        @Override
        public Configuration getBootConfiguration() {
            return Optional.ofNullable(this.container.getComponentByType(Configuration.class)).orElseGet(() -> new MapSettings().asConfig());
        }

        @Override
        public CoreExtension.Context addExtension(Object component) {
            Objects.requireNonNull(component, "component can't be null");
            if (!this.extensionFilter.test(component)) {
                return this;
            }
            if (!CoreExtensionsInstaller.this.addSupportedExtension(this.container, this.additionalSideFilter, this.extensionCategory, component)) {
                this.container.declareExtension(this.extensionCategory, component);
            }
            return this;
        }

        @Override
        public final CoreExtension.Context addExtensions(Object component, Object ... otherComponents) {
            this.addExtension(component);
            Arrays.stream(otherComponents).forEach(this::addExtension);
            return this;
        }

        @Override
        public <T> CoreExtension.Context addExtensions(Collection<T> components) {
            Objects.requireNonNull(components, "components can't be null");
            components.forEach(this::addExtension);
            return this;
        }
    }
}

