/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.staxmate.dom;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.Stax2ReaderAdapter;
import org.codehaus.stax2.ri.Stax2WriterAdapter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMConverter {
    protected final DocumentBuilder _docBuilder;
    protected boolean _inputCfgIgnoreWs = false;

    public DOMConverter() {
        this(DOMConverter._constructBuilder());
    }

    public DOMConverter(DocumentBuilder b) {
        this._docBuilder = b;
    }

    private static final DocumentBuilder _constructBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException pe) {
            throw new IllegalStateException(pe);
        }
    }

    public void setIgnoreWhitespace(boolean state) {
        this._inputCfgIgnoreWs = state;
    }

    public Document buildDocument(XMLStreamReader r) throws XMLStreamException {
        DocumentBuilder db;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new XMLStreamException(pce);
        }
        return this.buildDocument(r, db);
    }

    public Document buildDocument(XMLStreamReader r, DocumentBuilder docbuilder) throws XMLStreamException {
        Document doc = docbuilder.newDocument();
        this.buildDocument(r, doc);
        return doc;
    }

    public void buildDocument(XMLStreamReader r, Document doc) throws XMLStreamException {
        boolean wholeDoc = r.getEventType() == 7;
        XMLStreamReader2 sr = Stax2ReaderAdapter.wrapIfNecessary(r);
        QNameRecycler recycler = new QNameRecycler();
        boolean nsAware = DOMConverter._isNamespaceAware(sr);
        Node current = doc;
        int evtType = sr.getEventType();
        block14: while (true) {
            block26: {
                Node child;
                switch (evtType) {
                    case 12: {
                        child = doc.createCDATASection(sr.getText());
                        break;
                    }
                    case 6: {
                        if (this._inputCfgIgnoreWs || current == doc) break block26;
                    }
                    case 4: {
                        child = doc.createTextNode(sr.getText());
                        break;
                    }
                    {
                    }
                    case 5: {
                        child = doc.createComment(sr.getText());
                        break;
                    }
                    case 8: {
                        break block14;
                    }
                    case 2: {
                        current = current.getParentNode();
                        if (!(current != null && current != doc || wholeDoc)) {
                            break block14;
                        }
                        break block26;
                    }
                    case 14: 
                    case 15: {
                        break block26;
                    }
                    case 9: {
                        child = doc.createEntityReference(sr.getLocalName());
                        break;
                    }
                    case 3: {
                        child = doc.createProcessingInstruction(sr.getPITarget(), sr.getPIData());
                        break;
                    }
                    case 1: {
                        String prefix;
                        int i;
                        Element newElem;
                        String ln = sr.getLocalName();
                        if (nsAware) {
                            String qname = sr.getPrefixedName();
                            newElem = doc.createElementNS(sr.getNamespaceURI(), qname);
                        } else {
                            newElem = doc.createElement(ln);
                        }
                        int len = sr.getNamespaceCount();
                        for (i = 0; i < len; ++i) {
                            prefix = sr.getNamespacePrefix(i);
                            String qname = prefix == null || prefix.length() == 0 ? "xmlns" : recycler.getQualified("xmlns", prefix);
                            newElem.setAttributeNS("http://www.w3.org/2000/xmlns/", qname, sr.getNamespaceURI(i));
                        }
                        len = sr.getAttributeCount();
                        for (i = 0; i < len; ++i) {
                            ln = sr.getAttributeLocalName(i);
                            if (nsAware) {
                                prefix = sr.getAttributePrefix(i);
                                if (prefix != null && prefix.length() > 0) {
                                    ln = recycler.getQualified(prefix, ln);
                                }
                                newElem.setAttributeNS(sr.getAttributeNamespace(i), ln, sr.getAttributeValue(i));
                                continue;
                            }
                            newElem.setAttribute(ln, sr.getAttributeValue(i));
                        }
                        current.appendChild(newElem);
                        current = newElem;
                        break block26;
                    }
                    case 7: {
                        break block26;
                    }
                    case 11: {
                        break block26;
                    }
                    default: {
                        throw new XMLStreamException("Unrecognized iterator event type: " + sr.getEventType() + "; should not receive such types (broken stream reader?)");
                    }
                }
                if (child != null) {
                    current.appendChild(child);
                }
            }
            evtType = sr.next();
        }
    }

    public void writeDocument(Document doc, XMLStreamWriter sw0) throws XMLStreamException {
        XMLStreamWriter2 sw = Stax2WriterAdapter.wrapIfNecessary(sw0);
        sw.writeStartDocument();
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            this._writeNode(sw, child);
        }
        sw.writeEndDocument();
        sw.close();
    }

    public void writeFragment(NodeList nodes, XMLStreamWriter sw0) throws XMLStreamException {
        XMLStreamWriter2 sw = Stax2WriterAdapter.wrapIfNecessary(sw0);
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            this._writeNode(sw, nodes.item(i));
        }
    }

    public void writeFragment(Node node, XMLStreamWriter sw0) throws XMLStreamException {
        XMLStreamWriter2 sw = Stax2WriterAdapter.wrapIfNecessary(sw0);
        this._writeNode(sw, node);
    }

    protected static boolean _isNamespaceAware(XMLStreamReader r) throws XMLStreamException {
        Object o = r.getProperty("javax.xml.stream.isNamespaceAware");
        return !(o instanceof Boolean) || (Boolean)o != false;
    }

    protected void _writeNode(XMLStreamWriter2 sw, Node node) throws XMLStreamException {
        switch (node.getNodeType()) {
            case 1: {
                this._writeElement(sw, (Element)node);
                break;
            }
            case 3: {
                sw.writeCharacters(node.getNodeValue());
                break;
            }
            case 4: {
                sw.writeCData(node.getNodeValue());
                break;
            }
            case 8: {
                sw.writeComment(node.getNodeValue());
                break;
            }
            case 5: {
                sw.writeEntityRef(node.getNodeName());
                break;
            }
            case 7: {
                String target = node.getNodeName();
                String data = node.getNodeValue();
                if (data == null || data.length() == 0) {
                    sw.writeProcessingInstruction(target);
                    break;
                }
                sw.writeProcessingInstruction(target, data);
                break;
            }
            case 10: {
                sw.writeDTD(this._buildDTD((DocumentType)node));
                break;
            }
            default: {
                throw new XMLStreamException("Unrecognized or unexpected node class: " + node.getClass().getName());
            }
        }
    }

    protected String _buildDTD(DocumentType doctype) {
        String intSubset;
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE ");
        sb.append(doctype.getName());
        String pubId = doctype.getPublicId();
        String sysId = doctype.getSystemId();
        if (pubId == null || pubId.length() == 0) {
            if (sysId != null && sysId.length() > 0) {
                sb.append("SYSTEM \"");
                sb.append(sysId);
                sb.append('\"');
            }
        } else {
            sb.append("PUBLIC \"");
            sb.append(pubId);
            sb.append("\" \"");
            sb.append(sysId);
            sb.append('\"');
        }
        if ((intSubset = doctype.getInternalSubset()) != null && intSubset.length() > 0) {
            sb.append(" [");
            sb.append(intSubset);
            sb.append(']');
        }
        sb.append('>');
        return sb.toString();
    }

    protected void _writeElement(XMLStreamWriter2 sw, Element elem) throws XMLStreamException {
        String ln;
        String elemUri;
        String elemPrefix = elem.getPrefix();
        if (elemPrefix == null) {
            elemPrefix = "";
        }
        if ((elemUri = elem.getNamespaceURI()) == null) {
            elemUri = "";
        }
        if ((ln = elem.getLocalName()) == null) {
            ln = elem.getNodeName();
        }
        sw.writeStartElement(elemPrefix, ln, elemUri);
        NamedNodeMap attrs = elem.getAttributes();
        int len = attrs.getLength();
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)attrs.item(i);
            String aPrefix = attr.getPrefix();
            ln = attr.getLocalName();
            if (ln == null) {
                ln = attr.getName();
            }
            String value = attr.getValue();
            if (aPrefix == null || aPrefix.length() == 0) {
                if ("xmlns".equals(ln)) {
                    sw.writeDefaultNamespace(value);
                    continue;
                }
                sw.writeAttribute(ln, value);
                continue;
            }
            if ("xmlns".equals(aPrefix)) {
                sw.writeNamespace(ln, value);
                continue;
            }
            sw.writeAttribute(aPrefix, attr.getNamespaceURI(), ln, value);
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            this._writeNode(sw, child);
        }
        sw.writeEndElement();
    }

    static final class QNameRecycler {
        String _lastPrefix = null;
        String _lastLocalName = null;
        String _lastQName = null;

        public String getQualified(String prefix, String localName) {
            if (localName == this._lastLocalName && prefix == this._lastPrefix) {
                return this._lastQName;
            }
            this._lastLocalName = localName;
            this._lastPrefix = prefix;
            StringBuilder sb = new StringBuilder(1 + prefix.length() + localName.length());
            sb.append(prefix).append(':').append(localName);
            this._lastQName = sb.toString();
            return this._lastQName;
        }
    }
}

