/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.rule.RuleKey;

@Immutable
public class DefaultActiveRule
implements ActiveRule {
    private final RuleKey ruleKey;
    private final String severity;
    private final String internalKey;
    private final String language;
    private final String templateRuleKey;
    private final Map<String, String> params;
    private final long createdAt;
    private final long updatedAt;
    private final String qProfileKey;
    private final Set<RuleKey> deprecatedKeys;

    public DefaultActiveRule(NewActiveRule newActiveRule) {
        this.severity = newActiveRule.severity;
        this.internalKey = newActiveRule.internalKey;
        this.templateRuleKey = newActiveRule.templateRuleKey;
        this.ruleKey = newActiveRule.ruleKey;
        this.params = Collections.unmodifiableMap(new HashMap<String, String>(newActiveRule.params));
        this.language = newActiveRule.language;
        this.createdAt = newActiveRule.createdAt;
        this.updatedAt = newActiveRule.updatedAt;
        this.qProfileKey = newActiveRule.qProfileKey;
        this.deprecatedKeys = Collections.unmodifiableSet(new HashSet<RuleKey>(newActiveRule.deprecatedKeys));
    }

    @Override
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    @Override
    public String severity() {
        return this.severity;
    }

    @Override
    public String language() {
        return this.language;
    }

    @Override
    public String param(String key) {
        return this.params.get(key);
    }

    @Override
    public Map<String, String> params() {
        return this.params;
    }

    @Override
    public String internalKey() {
        return this.internalKey;
    }

    @Override
    public String templateRuleKey() {
        return this.templateRuleKey;
    }

    public long createdAt() {
        return this.createdAt;
    }

    public long updatedAt() {
        return this.updatedAt;
    }

    @Override
    public String qpKey() {
        return this.qProfileKey;
    }

    public Set<RuleKey> getDeprecatedKeys() {
        return this.deprecatedKeys;
    }
}

