/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.text.checks;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Scanner;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.plugins.text.api.CheckContext;
import org.sonar.plugins.text.checks.AbstractCheck;

@Rule(key="S6389")
public class BIDICharacterCheck
extends AbstractCheck {
    public static final String MESSAGE_FORMAT = "This line contains a bidirectional character in column %d. Make sure that using bidirectional characters is safe here.";
    private static final List<Character> BIDI_FORMATTING_CHARS = List.of(Character.valueOf('\u202a'), Character.valueOf('\u202b'), Character.valueOf('\u202d'), Character.valueOf('\u202e'));
    private static final List<Character> BIDI_ISOLATE_CHARS = List.of(Character.valueOf('\u2066'), Character.valueOf('\u2067'), Character.valueOf('\u2068'));
    private static final List<Character> BIDI_CHARS = new ArrayList<Character>(BIDI_FORMATTING_CHARS);
    private static final char PDF = '\u202c';
    private static final char PDI = '\u2069';

    @Override
    public void analyze(InputFile inputFile) {
        try (InputStream stream = inputFile.inputStream();){
            this.analyzeStream(stream, inputFile.charset());
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to read file input stream");
        }
    }

    private void analyzeStream(InputStream stream, Charset charset) {
        Scanner scanner = new Scanner(stream, charset);
        int lineNumber = 0;
        while (scanner.hasNextLine()) {
            BIDICharacterCheck.checkLine(this.ctx, scanner.nextLine(), ++lineNumber);
        }
    }

    private static void checkLine(CheckContext ctx, String lineContent, int lineNumber) {
        for (Character bidiChar : BIDI_CHARS) {
            if (lineContent.indexOf(bidiChar.charValue()) < 0) continue;
            BIDICharacterCheck.checkLineBIDIChars(ctx, lineContent, lineNumber);
            return;
        }
    }

    private static void checkLineBIDIChars(CheckContext ctx, String lineContent, int lineNumber) {
        ArrayDeque<Integer> unclosedFormattingColumns = new ArrayDeque<Integer>();
        ArrayDeque<Integer> unclosedIsolateColumns = new ArrayDeque<Integer>();
        for (int i = 0; i < lineContent.length(); ++i) {
            char currentChar = lineContent.charAt(i);
            if (BIDI_FORMATTING_CHARS.contains(Character.valueOf(currentChar))) {
                unclosedFormattingColumns.push(i);
                continue;
            }
            if (BIDI_ISOLATE_CHARS.contains(Character.valueOf(currentChar))) {
                unclosedIsolateColumns.push(i);
                continue;
            }
            if (currentChar == '\u202c' && !unclosedFormattingColumns.isEmpty()) {
                unclosedFormattingColumns.pop();
                continue;
            }
            if (currentChar != '\u2069' || unclosedIsolateColumns.isEmpty()) continue;
            unclosedIsolateColumns.pop();
        }
        BIDICharacterCheck.maybeReportOnFirstColumn(ctx, lineNumber, unclosedFormattingColumns, unclosedIsolateColumns);
    }

    private static void maybeReportOnFirstColumn(CheckContext ctx, int lineNumber, Deque<Integer> unclosedFormattingColumns, Deque<Integer> unclosedIsolateColumns) {
        if (unclosedFormattingColumns.isEmpty() && unclosedIsolateColumns.isEmpty()) {
            return;
        }
        int columnToReport = 0;
        columnToReport = !unclosedFormattingColumns.isEmpty() && !unclosedIsolateColumns.isEmpty() ? (unclosedFormattingColumns.getFirst() < unclosedIsolateColumns.getFirst() ? unclosedFormattingColumns.getFirst() : unclosedIsolateColumns.getFirst()) : (!unclosedFormattingColumns.isEmpty() ? unclosedFormattingColumns.getFirst().intValue() : unclosedIsolateColumns.getFirst().intValue());
        ctx.reportLineIssue(lineNumber, String.format(MESSAGE_FORMAT, columnToReport + 1));
    }

    static {
        BIDI_CHARS.addAll(BIDI_ISOLATE_CHARS);
    }
}

