/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import com.sonar.sslr.api.AstNode;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.semantic.AmbiguousSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolTableBuilder;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.PythonTreeMaker;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShed;
import org.sonar.python.types.TypeShedPythonFile;

public class TypeShedThirdParties {
    private TypeShedThirdParties() {
    }

    static Map<String, Symbol> getModuleSymbols(String moduleName, String categoryPath, Map<String, Set<Symbol>> initialSymbols) {
        ModuleDescription moduleDescription = TypeShedThirdParties.getResourceForModule(moduleName, categoryPath);
        if (moduleDescription == null) {
            return Collections.emptyMap();
        }
        TypeShedPythonFile file = new TypeShedPythonFile(moduleDescription.resource, moduleDescription.fileName);
        AstNode astNode = PythonParser.create().parse(file.content());
        FileInput fileInput = new PythonTreeMaker().fileInput(astNode);
        new SymbolTableBuilder(moduleDescription.packageName, file, ProjectLevelSymbolTable.from(initialSymbols)).visitFileInput(fileInput);
        fileInput.accept(new ReturnTypeVisitor());
        return fileInput.globalVariables().stream().map(symbol -> {
            ((SymbolImpl)symbol).removeUsages();
            return symbol;
        }).filter(s -> s.fullyQualifiedName() != null).collect(Collectors.toMap(Symbol::name, Function.identity(), (xva$0, xva$1) -> AmbiguousSymbolImpl.create(xva$0, xva$1)));
    }

    @Nullable
    private static ModuleDescription getResourceForModule(String moduleName, String categoryPath) {
        CharSequence[] moduleNameHierarchy = moduleName.split("\\.");
        String pathToModule = String.join((CharSequence)"/", moduleNameHierarchy);
        CharSequence moduleFileName = moduleNameHierarchy[moduleNameHierarchy.length - 1];
        String packageName = String.join((CharSequence)".", Arrays.copyOfRange(moduleNameHierarchy, 0, moduleNameHierarchy.length - 1));
        InputStream resource = TypeShed.class.getResourceAsStream(categoryPath + pathToModule + ".pyi");
        if (resource == null) {
            resource = TypeShed.class.getResourceAsStream(categoryPath + pathToModule + "/__init__.pyi");
            if (resource == null) {
                return null;
            }
            moduleFileName = "__init__";
            packageName = moduleName;
        }
        return new ModuleDescription(resource, (String)moduleFileName, packageName);
    }

    static Map<String, Symbol> commonSymbols(Map<String, Symbol> symbolsPython2, Map<String, Symbol> symbolsPython3, String packageName) {
        HashMap<String, Symbol> commonSymbols = new HashMap<String, Symbol>();
        symbolsPython3.forEach((localName, python3Symbol) -> {
            Symbol python2Symbol = (Symbol)symbolsPython2.get(localName);
            if (python2Symbol == null || python2Symbol == python3Symbol) {
                commonSymbols.put((String)localName, (Symbol)python3Symbol);
            } else {
                HashSet<Symbol> symbols = new HashSet<Symbol>();
                symbols.add(python2Symbol);
                symbols.add((Symbol)python3Symbol);
                commonSymbols.put((String)localName, new AmbiguousSymbolImpl((String)localName, packageName + "." + localName, (Set<Symbol>)symbols));
            }
        });
        symbolsPython2.forEach((localName, python2Symbol) -> {
            if (symbolsPython3.get(localName) == null) {
                commonSymbols.put((String)localName, (Symbol)python2Symbol);
            }
        });
        return commonSymbols;
    }

    private static class ReturnTypeVisitor
    extends BaseTreeVisitor {
        private ReturnTypeVisitor() {
        }

        private static void setDeclaredReturnType(Symbol symbol, FunctionDef functionDef) {
            TypeAnnotation returnTypeAnnotation = functionDef.returnTypeAnnotation();
            if (returnTypeAnnotation == null) {
                return;
            }
            if (symbol.is(Symbol.Kind.FUNCTION)) {
                FunctionSymbolImpl functionSymbol2 = (FunctionSymbolImpl)symbol;
                functionSymbol2.setDeclaredReturnType(InferredTypes.fromTypeshedTypeAnnotation(returnTypeAnnotation));
            } else if (symbol.is(Symbol.Kind.AMBIGUOUS)) {
                Optional.ofNullable(((FunctionDefImpl)functionDef).functionSymbol()).ifPresent(functionSymbol -> ReturnTypeVisitor.setDeclaredReturnType(functionSymbol, functionDef));
            }
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
            Optional.ofNullable(functionDef.name().symbol()).ifPresent(symbol -> {
                ReturnTypeVisitor.setDeclaredReturnType(symbol, functionDef);
                ReturnTypeVisitor.setParameterTypes(symbol, functionDef);
                ReturnTypeVisitor.setAnnotatedReturnType(symbol, functionDef);
            });
            super.visitFunctionDef(functionDef);
        }

        @Override
        public void visitAnnotatedAssignment(AnnotatedAssignment annotatedAssignment) {
            if (annotatedAssignment.variable().is(Tree.Kind.NAME)) {
                Name variable = (Name)annotatedAssignment.variable();
                Optional.ofNullable(variable.symbol()).ifPresent(symbol -> ReturnTypeVisitor.setAnnotatedType(symbol, annotatedAssignment));
            }
            super.visitAnnotatedAssignment(annotatedAssignment);
        }

        private static void setAnnotatedType(Symbol symbol, AnnotatedAssignment annotatedAssignment) {
            TypeAnnotation typeAnnotation = annotatedAssignment.annotation();
            if (symbol.is(Symbol.Kind.OTHER)) {
                SymbolImpl other = (SymbolImpl)symbol;
                other.setAnnotatedTypeName(typeAnnotation);
            }
        }

        private static void setAnnotatedReturnType(Symbol symbol, FunctionDef functionDef) {
            TypeAnnotation typeAnnotation = functionDef.returnTypeAnnotation();
            if (symbol.is(Symbol.Kind.FUNCTION)) {
                ((FunctionSymbolImpl)symbol).setAnnotatedReturnTypeName(typeAnnotation);
            } else if (symbol.is(Symbol.Kind.AMBIGUOUS)) {
                Optional.ofNullable(((FunctionDefImpl)functionDef).functionSymbol()).ifPresent(functionSymbol -> ReturnTypeVisitor.setAnnotatedReturnType(functionSymbol, functionDef));
            }
        }

        private static void setParameterTypes(Symbol symbol, FunctionDef functionDef) {
            FunctionSymbol funcDefSymbol;
            if (symbol.is(Symbol.Kind.FUNCTION)) {
                FunctionSymbolImpl functionSymbol = (FunctionSymbolImpl)symbol;
                ParameterList parameters = functionDef.parameters();
                if (parameters != null) {
                    functionSymbol.setParametersWithType(parameters);
                }
            } else if (symbol.is(Symbol.Kind.AMBIGUOUS) && (funcDefSymbol = ((FunctionDefImpl)functionDef).functionSymbol()) != null) {
                ReturnTypeVisitor.setParameterTypes(funcDefSymbol, functionDef);
            }
        }
    }

    private static class ModuleDescription {
        InputStream resource;
        String fileName;
        String packageName;

        ModuleDescription(InputStream resource, String fileName, String packageName) {
            this.resource = resource;
            this.fileName = fileName;
            this.packageName = packageName;
        }
    }
}

