/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class IfStatementImpl
extends PyTree
implements IfStatement {
    private final Token keyword;
    private final Expression condition;
    private final Token colon;
    @CheckForNull
    private final Token newLine;
    @CheckForNull
    private final Token indent;
    private final StatementList statements;
    private final Token dedent;
    private final List<IfStatement> elifBranches;
    private final boolean isElif;
    @CheckForNull
    private final ElseClause elseClause;

    public IfStatementImpl(Token ifKeyword, Expression condition, Token colon, @CheckForNull Token newLine, @CheckForNull Token indent, StatementList statements, @CheckForNull Token dedent, List<IfStatement> elifBranches, @CheckForNull ElseClause elseClause) {
        this.keyword = ifKeyword;
        this.condition = condition;
        this.colon = colon;
        this.newLine = newLine;
        this.indent = indent;
        this.statements = statements;
        this.dedent = dedent;
        this.elifBranches = elifBranches;
        this.isElif = false;
        this.elseClause = elseClause;
    }

    public IfStatementImpl(Token elifKeyword, Expression condition, Token colon, @CheckForNull Token newLine, @CheckForNull Token indent, StatementList statements, @CheckForNull Token dedent) {
        this.keyword = elifKeyword;
        this.condition = condition;
        this.colon = colon;
        this.newLine = newLine;
        this.indent = indent;
        this.statements = statements;
        this.dedent = dedent;
        this.elifBranches = Collections.emptyList();
        this.isElif = true;
        this.elseClause = null;
    }

    @Override
    public Token keyword() {
        return this.keyword;
    }

    @Override
    public Expression condition() {
        return this.condition;
    }

    @Override
    public StatementList body() {
        return this.statements;
    }

    @Override
    public List<IfStatement> elifBranches() {
        return this.elifBranches;
    }

    @Override
    public boolean isElif() {
        return this.isElif;
    }

    @Override
    @CheckForNull
    public ElseClause elseBranch() {
        return this.elseClause;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IF_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitIfStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Arrays.asList(this.keyword, this.condition, this.colon, this.newLine, this.indent, this.statements, this.dedent), this.elifBranches, Collections.singletonList(this.elseClause)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

