/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S5706")
public class NoReRaiseInExitCheck
extends PythonSubscriptionCheck {
    private static Symbol extractPackedParameter(ParameterList parameterList) {
        if (parameterList.nonTuple().size() != 2) {
            return null;
        }
        Parameter parameter = parameterList.nonTuple().get(1);
        if (parameter.starToken() == null) {
            return null;
        }
        Name name = parameter.name();
        if (name == null) {
            return null;
        }
        return name.symbol();
    }

    private static Symbol extractCaughtExceptionParameter(ParameterList parameterList) {
        List<Parameter> regularParams = parameterList.nonTuple();
        if (regularParams.size() != 4 || !regularParams.equals(parameterList.all())) {
            return null;
        }
        Parameter parameter = regularParams.get(2);
        Name name = parameter.name();
        if (name == null) {
            return null;
        }
        return name.symbol();
    }

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            ParameterList parameterList = functionDef.parameters();
            if (!functionDef.name().name().equals("__exit__") || parameterList == null) {
                return;
            }
            Symbol caughtException = NoReRaiseInExitCheck.extractCaughtExceptionParameter(parameterList);
            Symbol packedParameter = NoReRaiseInExitCheck.extractPackedParameter(parameterList);
            RaiseVisitor visitor = new RaiseVisitor(caughtException, packedParameter);
            functionDef.accept(visitor);
            for (RaiseStatement bareRaise : visitor.nonCompliantRaises) {
                ctx.addIssue(bareRaise, "Remove this \"raise\" statement and return \"False\" instead.");
            }
        });
    }

    private static class RaiseVisitor
    extends BaseTreeVisitor {
        private Symbol caughtException;
        private Symbol packedParameter;
        private List<RaiseStatement> nonCompliantRaises = new ArrayList<RaiseStatement>();

        public RaiseVisitor(Symbol caughtException, Symbol packedParameter) {
            this.caughtException = caughtException;
            this.packedParameter = packedParameter;
        }

        @Override
        public void visitExceptClause(ExceptClause exceptClause) {
        }

        @Override
        public void visitRaiseStatement(RaiseStatement pyRaiseStatementTree) {
            SubscriptionExpression subscriptionExpression;
            Expression objectExpression;
            if (pyRaiseStatementTree.expressions().isEmpty()) {
                this.nonCompliantRaises.add(pyRaiseStatementTree);
                return;
            }
            Expression raisedException = pyRaiseStatementTree.expressions().get(0);
            if (raisedException instanceof HasSymbol && Objects.equals(((HasSymbol)((Object)raisedException)).symbol(), this.caughtException)) {
                this.nonCompliantRaises.add(pyRaiseStatementTree);
            }
            if (raisedException.is(Tree.Kind.SUBSCRIPTION) && (objectExpression = (subscriptionExpression = (SubscriptionExpression)raisedException).object()) instanceof HasSymbol && Objects.equals(((HasSymbol)((Object)objectExpression)).symbol(), this.packedParameter)) {
                this.nonCompliantRaises.add(pyRaiseStatementTree);
            }
        }
    }
}

