/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S3329")
public class CipherBlockChainingCheck
extends PythonSubscriptionCheck {
    private static final HashSet<String> PYCRYPTO_SENSITIVE_FQNS = new HashSet();
    private static final String CRYPTOGRAPHY_SENSITIVE_FQN = "cryptography.hazmat.primitives.ciphers.Cipher";
    private static final String MESSAGE = "Use a dynamically-generated, random IV.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, CipherBlockChainingCheck::checkCallExpression);
    }

    private static void checkCallExpression(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (calleeSymbol == null || calleeSymbol.fullyQualifiedName() == null) {
            return;
        }
        if (PYCRYPTO_SENSITIVE_FQNS.contains(calleeSymbol.fullyQualifiedName())) {
            CipherBlockChainingCheck.checkPyCryptoCall(callExpression, ctx);
        }
        if (CRYPTOGRAPHY_SENSITIVE_FQN.equals(calleeSymbol.fullyQualifiedName())) {
            CipherBlockChainingCheck.checkCrypographyCall(callExpression, ctx);
        }
    }

    private static void checkCrypographyCall(CallExpression callExpression, SubscriptionContext ctx) {
        RegularArgument modeArgument = TreeUtils.nthArgumentOrKeyword(1, "mode", callExpression.arguments());
        if (modeArgument == null) {
            return;
        }
        Expression modeArgumentExpression = modeArgument.expression();
        if (!modeArgumentExpression.is(Tree.Kind.CALL_EXPR)) {
            return;
        }
        CallExpression modeCallExpression = (CallExpression)modeArgumentExpression;
        Symbol calleeSymbol = modeCallExpression.calleeSymbol();
        if (calleeSymbol == null || !"CBC".equals(calleeSymbol.name())) {
            return;
        }
        RegularArgument initializationVector = TreeUtils.nthArgumentOrKeyword(0, "initialization_vector", modeCallExpression.arguments());
        if (initializationVector == null || !CipherBlockChainingCheck.isStaticInitializationVector(initializationVector.expression(), new HashSet<Expression>())) {
            return;
        }
        AssignmentStatement assignmentStatement = (AssignmentStatement)TreeUtils.firstAncestorOfKind(callExpression, Tree.Kind.ASSIGNMENT_STMT);
        if (assignmentStatement == null || assignmentStatement.assignedValue() != callExpression) {
            return;
        }
        CipherBlockChainingCheck.checkAssignmentStatement(assignmentStatement, callExpression, "encryptor", ctx);
    }

    private static void checkPyCryptoCall(CallExpression callExpression, SubscriptionContext ctx) {
        RegularArgument modeArgument = TreeUtils.nthArgumentOrKeyword(1, "mode", callExpression.arguments());
        if (modeArgument == null) {
            return;
        }
        Expression modeArgumentExpression = modeArgument.expression();
        if (!(modeArgumentExpression instanceof HasSymbol)) {
            return;
        }
        Symbol symbol = ((HasSymbol)((Object)modeArgumentExpression)).symbol();
        if (symbol == null || !"MODE_CBC".equals(symbol.name())) {
            return;
        }
        RegularArgument ivArgument = TreeUtils.nthArgumentOrKeyword(2, "iv", callExpression.arguments());
        if (ivArgument == null || !CipherBlockChainingCheck.isStaticInitializationVector(ivArgument.expression(), new HashSet<Expression>())) {
            return;
        }
        AssignmentStatement assignmentStatement = (AssignmentStatement)TreeUtils.firstAncestorOfKind(callExpression, Tree.Kind.ASSIGNMENT_STMT);
        if (assignmentStatement == null || assignmentStatement.assignedValue() != callExpression) {
            return;
        }
        CipherBlockChainingCheck.checkAssignmentStatement(assignmentStatement, callExpression, "encrypt", ctx);
    }

    private static void checkAssignmentStatement(AssignmentStatement assignmentStatement, CallExpression callExpression, String suspiciousCallee, SubscriptionContext ctx) {
        assignmentStatement.lhsExpressions().stream().filter(exprList -> exprList.expressions().size() == 1).flatMap(exprList -> exprList.expressions().stream()).filter(expression -> expression.is(Tree.Kind.NAME)).forEach(name -> {
            Symbol symbol = ((Name)name).symbol();
            if (symbol == null) {
                return;
            }
            symbol.usages().stream().map(Usage::tree).filter(t -> CipherBlockChainingCheck.isWithinCallTo(t, suspiciousCallee)).findFirst().ifPresent(t -> ctx.addIssue((Tree)t, MESSAGE).secondary(callExpression, null));
        });
    }

    private static boolean isWithinCallTo(Tree tree, String calleeName) {
        CallExpression callExpression = (CallExpression)TreeUtils.firstAncestorOfKind(tree, Tree.Kind.CALL_EXPR);
        if (callExpression == null) {
            return false;
        }
        return callExpression.callee().is(Tree.Kind.QUALIFIED_EXPR) && ((QualifiedExpression)callExpression.callee()).name().name().equals(calleeName);
    }

    private static boolean isStaticInitializationVector(Expression expression, Set<Expression> checkedExpressions) {
        if (checkedExpressions.contains(expression)) {
            return false;
        }
        checkedExpressions.add(expression);
        if (expression.is(Tree.Kind.CALL_EXPR) || TreeUtils.hasDescendant(expression, tree -> tree.is(Tree.Kind.CALL_EXPR))) {
            return false;
        }
        if (expression.is(Tree.Kind.NAME)) {
            Expression singleAssignedValue = Expressions.singleAssignedValue((Name)expression);
            if (singleAssignedValue == null) {
                return false;
            }
            return CipherBlockChainingCheck.isStaticInitializationVector(singleAssignedValue, checkedExpressions);
        }
        return true;
    }

    static {
        for (String libraryName : Arrays.asList("Cryptodome", "Crypto")) {
            for (String vulnerableMethodName : Arrays.asList("AES", "ARC2", "Blowfish", "CAST", "DES", "DES3")) {
                PYCRYPTO_SENSITIVE_FQNS.add(String.format("%s.Cipher.%s.new", libraryName, vulnerableMethodName));
            }
        }
    }
}

