/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;

@Rule(key="S5714")
public class BooleanExpressionInExceptCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.EXCEPT_CLAUSE, ctx -> {
            ExceptClause except = (ExceptClause)ctx.syntaxNode();
            Expression exception = Expressions.removeParentheses(except.exception());
            if (exception != null && exception.is(Tree.Kind.OR, Tree.Kind.AND)) {
                ctx.addIssue(exception, "Rewrite this \"except\" expression as a tuple of exception classes.");
            }
        });
    }
}

