---
title: JavaScript/TypeScript/CSS
key: javascript
---

<!-- static -->
<!-- update_center:javascript -->
<!-- /static -->

## Prerequisites

In order to analyze JavaScript, TypeScript or CSS code, you need to have supported version of Node.js installed on the
machine running the scan. Supported versions are previous LTS version v14 and the latest version - v16. Odd
(non LTS) versions might work, but are not actively tested. We recommend using the latest available LTS version 
(v16 as of today) for optimal stability and performance. v10 and v12 are still supported, but they already reached end-of-life and
are deprecated.

If `node` is not available in the PATH, you can use property `sonar.nodejs.executable` to set an absolute path to
Node.js executable.

If you have a community plugin for CSS analysis installed on your SonarQube instance it will conflict with analysis of CSS, so it should be removed.
 
## Language-Specific Properties

Discover and update the JavaScript / TypeScript [properties](/analysis/analysis-parameters/) in: **<!-- sonarcloud -->Project <!-- /sonarcloud -->[Administration > General Settings > JavaScript / TypeScript](/#sonarqube-admin#/admin/settings?category=javascript+%2F+typescript)**.

Discover and update the CSS [properties](/analysis/analysis-parameters/) in: **<!-- sonarcloud -->Project <!-- /sonarcloud -->[Administration > General Settings > CSS](/#sonarqube-admin#/admin/settings?category=css)**.

## Supported Frameworks, Versions and Languages
* ECMAScript 3, 5, 2015, 2016, 2017, 2018, 2019, and 2020
* TypeScript 4.4
* React JSX
* Vue.js
* Flow
* CSS, SCSS, Less, also 'style' inside PHP, HTML and VueJS files

## Troubleshooting

### Slow or unresponsive analysis

On a big project, more memory may need to be allocated to analyze the project. This would be manifested by analysis getting stuck and the following stacktrace might appear in the logs

```
ERROR: Failed to get response while analyzing [file].ts
java.io.InterruptedIOException: timeout
```   
You can use `sonar.javascript.node.maxspace` property to allow the analysis to use more memory. Set this property to `4096` or `8192` for big projects. This property should be set in `sonar-project.properties` file or on command line for scanner (with `-Dsonar.javascript.node.maxspace=4096`).


### Default exclusions for JS/TS

By default, analysis will exclude files from dependencies in usual directories, such as `node_modules`, 
`bower_components`, `dist`, `vendor`, and `external`. It will also ignore `.d.ts` files. If for some reason analysis of files in these directories
is desired, it can be configured by setting `sonar.javascript.exclusions` property to empty value, i.e. 
`sonar.javascript.exclusions=""`, or to comma separated list of paths to be excluded. This property will exclude only JavaScript/TypeScript files, while `sonar.exclusions` property will exclude all files. `sonar.exclusions` property should be 
preferred to configure general exclusions for the project.

### Custom rules for JS/TS
Custom rules are not supported by the analyzer. As an alternative we suggest you to have a look at [ESLint](https://eslint.org/docs/developer-guide/), it provides custom rules that you can then import thanks to the [External Issues](/analysis/external-issues/) feature.

## Related Pages
* [Importing External Issues](/analysis/external-issues/) (ESLint, TSLint, StyleLint)
* [Test Coverage & Execution](/analysis/coverage/) (LCOV format)
* [SonarJS Plugin for ESLint](https://github.com/SonarSource/eslint-plugin-sonarjs)
<!-- sonarqube -->
* [Adding Coding Rules](/extend/adding-coding-rules/)
<!-- /sonarqube -->
