/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.sonar.java.ast.parser.ArgumentListTreeImpl;
import org.sonar.java.model.Symbols;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonarsource.analyzer.commons.collections.ListUtils;

public class MethodInvocationTreeImpl
extends AssessableExpressionTree
implements MethodInvocationTree {
    private final ExpressionTree methodSelect;
    private final Arguments arguments;
    @Nullable
    private TypeArguments typeArguments;
    @Nullable
    public IMethodBinding methodBinding;

    public MethodInvocationTreeImpl(ExpressionTree methodSelect, @Nullable TypeArguments typeArguments, ArgumentListTreeImpl arguments) {
        this.methodSelect = Objects.requireNonNull(methodSelect);
        this.typeArguments = typeArguments;
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.METHOD_INVOCATION;
    }

    @Override
    @Nullable
    public TypeArguments typeArguments() {
        return this.typeArguments;
    }

    @Override
    public SyntaxToken firstToken() {
        ExpressionTree expression;
        SyntaxToken firstToken;
        if (this.typeArguments() != null && this.methodSelect.is(Tree.Kind.MEMBER_SELECT) && (firstToken = (expression = ((MemberSelectExpressionTree)this.methodSelect).expression()).firstToken()) != null) {
            return firstToken;
        }
        return super.firstToken();
    }

    @Override
    public ExpressionTree methodSelect() {
        return this.methodSelect;
    }

    @Override
    public Arguments arguments() {
        return this.arguments;
    }

    @Override
    public Symbol symbol() {
        return this.methodBinding != null ? this.root.sema.methodSymbol(this.methodBinding) : Symbols.unknownMethodSymbol;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMethodInvocation(this);
    }

    @Override
    public List<Tree> children() {
        return ListUtils.concat(this.typeArguments != null ? Collections.singletonList(this.typeArguments) : Collections.emptyList(), Arrays.asList(this.methodSelect, this.arguments));
    }
}

