/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.PatternInstanceOfTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class InstanceOfTreeImpl
extends AssessableExpressionTree
implements InstanceOfTree,
PatternInstanceOfTree {
    private final Tree.Kind kind;
    private final ExpressionTree expression;
    private final InternalSyntaxToken instanceofToken;
    @Nullable
    private final TypeTree type;
    @Nullable
    private final VariableTree variable;

    private InstanceOfTreeImpl(Tree.Kind kind, ExpressionTree expression, InternalSyntaxToken instanceofToken, @Nullable TypeTree type, @Nullable VariableTree variable) {
        this.kind = kind;
        this.expression = expression;
        this.instanceofToken = instanceofToken;
        this.type = type;
        this.variable = variable;
    }

    public InstanceOfTreeImpl(ExpressionTree expression, InternalSyntaxToken instanceofToken, TypeTree type) {
        this(Tree.Kind.INSTANCE_OF, expression, instanceofToken, type, null);
    }

    public InstanceOfTreeImpl(ExpressionTree expression, InternalSyntaxToken instanceofToken, VariableTree variable) {
        this(Tree.Kind.PATTERN_INSTANCE_OF, expression, instanceofToken, null, variable);
    }

    @Override
    public Tree.Kind kind() {
        return this.kind;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken instanceofKeyword() {
        return this.instanceofToken;
    }

    @Override
    public TypeTree type() {
        return this.type;
    }

    @Override
    public VariableTree variable() {
        return this.variable;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        if (this.kind == Tree.Kind.INSTANCE_OF) {
            visitor.visitInstanceOf(this);
        } else {
            visitor.visitPatternInstanceOf(this);
        }
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.expression, this.instanceofToken, this.kind == Tree.Kind.INSTANCE_OF ? this.type : this.variable);
    }
}

