/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.AnnotationsHelper;
import org.sonar.java.checks.helpers.Javadoc;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.helpers.UnresolvedIdentifiersVisitor;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S1172")
public class UnusedMethodParameterCheck
extends IssuableSubscriptionVisitor {
    private static final String PRIMARY_SINGULAR_MESSAGE_FORMAT = "Remove this unused method parameter %s.";
    private static final String PRIMARY_PLURAL_MESSAGE_FORMAT = "Remove these unused method parameters %s.";
    private static final String SECONDARY_MESSAGE_FORMAT = "Parameter \"%s\"";
    private static final String QUICK_FIX_MESSAGE = "Remove \"%s\"";
    private static final String AUTHORIZED_ANNOTATION = "javax.enterprise.event.Observes";
    private static final String SUPPRESS_WARNINGS_ANNOTATION = "java.lang.SuppressWarnings";
    private static final Set<String> EXCLUDED_WARNINGS_SUPPRESSIONS = SetUtils.immutableSetOf("\"rawtypes\"", "\"unchecked\"");
    private static final MethodMatchers SERIALIZABLE_METHODS = MethodMatchers.or(MethodMatchers.create().ofAnyType().names("writeObject").addParametersMatcher("java.io.ObjectOutputStream").build(), MethodMatchers.create().ofAnyType().names("readObject").addParametersMatcher("java.io.ObjectInputStream").build());
    private static final String STRUTS_ACTION_SUPERCLASS = "org.apache.struts.action.Action";
    private static final Set<String> EXCLUDED_STRUTS_ACTION_PARAMETER_TYPES = SetUtils.immutableSetOf("org.apache.struts.action.ActionMapping", "org.apache.struts.action.ActionForm", "javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse");
    private static final UnresolvedIdentifiersVisitor UNRESOLVED_IDENTIFIERS_VISITOR = new UnresolvedIdentifiersVisitor();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (methodTree.block() == null || methodTree.parameters().isEmpty() || UnusedMethodParameterCheck.isExcluded(methodTree)) {
            return;
        }
        HashSet<String> undocumentedParameters = new HashSet<String>(new Javadoc(methodTree).undocumentedParameters());
        boolean overridableMethod = JUtils.isOverridable(methodTree.symbol());
        List<Object> unused = new ArrayList();
        for (VariableTree parameter : methodTree.parameters()) {
            Symbol symbol = parameter.symbol();
            if (!symbol.usages().isEmpty() || UnusedMethodParameterCheck.isAnnotatedWithAuthorizedAnnotation(symbol) || UnusedMethodParameterCheck.isStrutsActionParameter(parameter) || overridableMethod && !undocumentedParameters.contains(symbol.name())) continue;
            unused.add(parameter.simpleName());
        }
        Set<String> unresolvedIdentifierNames = UNRESOLVED_IDENTIFIERS_VISITOR.check(methodTree.block());
        if (!(unused = unused.stream().filter(id -> !unresolvedIdentifierNames.contains(id.name())).collect(Collectors.toList())).isEmpty()) {
            this.reportUnusedParameters(methodTree, unused);
        }
    }

    private static boolean isAnnotatedWithAuthorizedAnnotation(Symbol symbol) {
        SymbolMetadata metadata = symbol.metadata();
        return metadata.isAnnotatedWith(AUTHORIZED_ANNOTATION) || AnnotationsHelper.hasUnknownAnnotation(metadata);
    }

    private void reportUnusedParameters(MethodTree methodTree, List<IdentifierTree> unused) {
        IdentifierTree firstUnused = unused.get(0);
        List secondaryLocations = unused.stream().skip(1L).map(identifier -> new JavaFileScannerContext.Location(String.format(SECONDARY_MESSAGE_FORMAT, identifier.name()), (Tree)identifier)).collect(Collectors.toList());
        String parameterNames = unused.stream().map(identifier -> "\"" + identifier.name() + "\"").collect(Collectors.joining(", "));
        ((InternalJavaIssueBuilder)((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(firstUnused).withMessage(unused.size() > 1 ? PRIMARY_PLURAL_MESSAGE_FORMAT : PRIMARY_SINGULAR_MESSAGE_FORMAT, parameterNames).withSecondaries(secondaryLocations)).withQuickFixes(() -> UnusedMethodParameterCheck.createQuickFixes(methodTree, unused))).report();
    }

    private static List<JavaQuickFix> createQuickFixes(MethodTree methodTree, List<IdentifierTree> unused) {
        ArrayList<JavaQuickFix> quickFixes = new ArrayList<JavaQuickFix>();
        List<VariableTree> parameters = methodTree.parameters();
        for (int i = 0; i < parameters.size(); ++i) {
            AnalyzerMessage.TextSpan textSpanToRemove;
            boolean isLast;
            VariableTree parameter = parameters.get(i);
            if (!unused.contains(parameter.simpleName())) continue;
            boolean isFirst = i == 0;
            boolean bl = isLast = i == parameters.size() - 1;
            if (isFirst && isLast) {
                textSpanToRemove = AnalyzerMessage.textSpanBetween(methodTree.openParenToken(), false, methodTree.closeParenToken(), false);
            } else if (isLast) {
                VariableTree previousParameter = parameters.get(i - 1);
                textSpanToRemove = AnalyzerMessage.textSpanBetween(previousParameter.endToken(), true, methodTree.closeParenToken(), false);
            } else {
                VariableTree nextParameter = parameters.get(i + 1);
                textSpanToRemove = AnalyzerMessage.textSpanBetween(parameter, true, nextParameter, false);
            }
            quickFixes.add(JavaQuickFix.newQuickFix(QUICK_FIX_MESSAGE, parameter.simpleName().name()).addTextEdit(JavaTextEdit.removeTextSpan(textSpanToRemove)).build());
        }
        return quickFixes;
    }

    private static boolean isExcluded(MethodTree tree) {
        return MethodTreeUtils.isMainMethod(tree) || UnusedMethodParameterCheck.isAnnotated(tree) || UnusedMethodParameterCheck.isOverriding(tree) || UnusedMethodParameterCheck.isSerializableMethod(tree) || UnusedMethodParameterCheck.isDesignedForExtension(tree) || UnusedMethodParameterCheck.isUsedAsMethodReference(tree);
    }

    private static boolean isAnnotated(MethodTree tree) {
        return tree.modifiers().annotations().stream().anyMatch(annotation -> !UnusedMethodParameterCheck.isExcludedLiteral(annotation));
    }

    private static boolean isExcludedLiteral(Tree tree) {
        if (tree.is(Tree.Kind.ANNOTATION)) {
            AnnotationTree annotationTree = (AnnotationTree)tree;
            return annotationTree.annotationType().symbolType().is(SUPPRESS_WARNINGS_ANNOTATION) && annotationTree.arguments().stream().allMatch(UnusedMethodParameterCheck::isExcludedLiteral);
        }
        if (tree.is(Tree.Kind.STRING_LITERAL)) {
            return EXCLUDED_WARNINGS_SUPPRESSIONS.contains(((LiteralTree)tree).value());
        }
        if (tree.is(Tree.Kind.NEW_ARRAY)) {
            return ((NewArrayTree)tree).initializers().stream().allMatch(UnusedMethodParameterCheck::isExcludedLiteral);
        }
        return false;
    }

    private static boolean isDesignedForExtension(MethodTree tree) {
        if (tree.symbol().enclosingClass().isFinal()) {
            return false;
        }
        ModifiersTree modifiers = tree.modifiers();
        return ModifiersUtils.hasModifier(modifiers, Modifier.DEFAULT) || !ModifiersUtils.hasModifier(modifiers, Modifier.PRIVATE) && UnusedMethodParameterCheck.isEmptyOrThrowStatement(tree.block());
    }

    private static boolean isStrutsActionParameter(VariableTree variableTree) {
        Type superClass = variableTree.symbol().enclosingClass().superClass();
        return superClass != null && superClass.isSubtypeOf(STRUTS_ACTION_SUPERCLASS) && EXCLUDED_STRUTS_ACTION_PARAMETER_TYPES.contains(variableTree.symbol().type().fullyQualifiedName());
    }

    private static boolean isEmptyOrThrowStatement(BlockTree block) {
        return block.body().isEmpty() || block.body().size() == 1 && block.body().get(0).is(Tree.Kind.THROW_STATEMENT);
    }

    private static boolean isSerializableMethod(MethodTree methodTree) {
        return ModifiersUtils.hasModifier(methodTree.modifiers(), Modifier.PRIVATE) && SERIALIZABLE_METHODS.matches(methodTree);
    }

    private static boolean isOverriding(MethodTree tree) {
        return !Boolean.FALSE.equals(tree.isOverriding());
    }

    private static boolean isUsedAsMethodReference(MethodTree tree) {
        return tree.symbol().usages().stream().anyMatch(identifier -> identifier.parent().is(Tree.Kind.METHOD_REFERENCE));
    }
}

