/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S5967")
public class JUnitCompatibleAnnotationsCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> ANNOTATIONS = SetUtils.immutableSetOf("org.junit.jupiter.api.Test", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.TestFactory", "org.junit.jupiter.api.TestTemplate", "org.junit.jupiter.params.ParameterizedTest");

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        List<AnnotationTree> annotationTrees = method.modifiers().annotations();
        List<JavaFileScannerContext.Location> locations = annotationTrees.stream().filter(annotation -> ANNOTATIONS.contains(annotation.annotationType().symbolType().fullyQualifiedName())).map(annotationTree -> new JavaFileScannerContext.Location("Incompatible annotation", (Tree)annotationTree)).collect(Collectors.toList());
        if (locations.size() > 1) {
            this.reportIssue(method.simpleName(), "Remove one of these conflicting annotations.", locations, null);
        }
    }
}

