/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import java.util.List;
import java.util.Set;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

public final class SerializableContract {
    public static final Set<String> SERIALIZABLE_CONTRACT_METHODS = SetUtils.immutableSetOf("writeObject", "readObject", "writeReplace", "readResolve", "readObjectNoData");
    public static final String SERIAL_VERSION_UID_FIELD = "serialVersionUID";

    private SerializableContract() {
    }

    public static boolean hasSpecialHandlingSerializationMethods(ClassTree classTree) {
        boolean hasWriteObject = false;
        boolean hasReadObject = false;
        String classFullyQualifiedName = classTree.symbol().type().fullyQualifiedName();
        for (Tree member : classTree.members()) {
            MethodTree methodTree;
            MethodMatchers writeObjectMatcher = SerializableContract.writeObjectMatcher(classFullyQualifiedName);
            MethodMatchers readObjectMatcher = SerializableContract.readObjectMatcher(classFullyQualifiedName);
            if (!member.is(Tree.Kind.METHOD) || !ModifiersUtils.hasModifier((methodTree = (MethodTree)member).modifiers(), Modifier.PRIVATE)) continue;
            hasWriteObject |= writeObjectMatcher.matches(methodTree) && SerializableContract.methodThrows(methodTree, "java.io.IOException");
            hasReadObject |= readObjectMatcher.matches(methodTree) && SerializableContract.methodThrows(methodTree, "java.io.IOException", "java.lang.ClassNotFoundException");
        }
        return hasReadObject && hasWriteObject;
    }

    public static MethodMatchers readObjectMatcher(String classFullyQualifiedName) {
        return MethodMatchers.create().ofTypes(classFullyQualifiedName).names("readObject").addParametersMatcher("java.io.ObjectInputStream").build();
    }

    public static MethodMatchers writeObjectMatcher(String classFullyQualifiedName) {
        return MethodMatchers.create().ofTypes(classFullyQualifiedName).names("writeObject").addParametersMatcher("java.io.ObjectOutputStream").build();
    }

    private static boolean methodThrows(MethodTree methodTree, String ... throwClauseFullyQualifiedNames) {
        List<Type> thrownTypes = methodTree.symbol().thrownTypes();
        if (thrownTypes.isEmpty() || thrownTypes.size() != throwClauseFullyQualifiedNames.length) {
            return false;
        }
        for (Type thrownType : thrownTypes) {
            boolean match = false;
            for (String fullyQualifiedName : throwClauseFullyQualifiedNames) {
                match |= thrownType.is(fullyQualifiedName);
            }
            if (match) continue;
            return false;
        }
        return true;
    }
}

