/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.EndOfAnalysisCheck;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5693")
public class ExcessiveContentRequestCheck
extends IssuableSubscriptionVisitor
implements EndOfAnalysisCheck {
    @RuleProperty(key="fileUploadSizeLimit", description="The maximum size of HTTP requests handling file uploads (in bytes).", defaultValue="8388608")
    public long fileUploadSizeLimit = 0x800000L;
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final long BYTES_PER_TB = 0x10000000000L;
    private static final long DEFAULT_MAX = 0x800000L;
    private static final String MESSAGE_EXCEED_SIZE = "The content length limit of %d bytes is greater than the defined limit of %d; make sure it is safe here.";
    private static final String MESSAGE_SIZE_NOT_SET = "Make sure not setting any maximum content length limit is safe here.";
    private static final Pattern DATA_SIZE_PATTERN = Pattern.compile("^([+\\-]?\\d+)([a-zA-Z]{0,2})$");
    private static final String MULTIPART_RESOLVER = "org.springframework.web.multipart.commons.CommonsMultipartResolver";
    private static final String MULTIPART_CONFIG = "org.springframework.boot.web.servlet.MultipartConfigFactory";
    private static final MethodMatchers METHODS_SETTING_MAX_SIZE = MethodMatchers.or(MethodMatchers.create().ofSubTypes("org.springframework.web.multipart.commons.CommonsMultipartResolver").names("setMaxUploadSize").addParametersMatcher("long").build(), MethodMatchers.create().ofSubTypes("org.springframework.boot.web.servlet.MultipartConfigFactory").names("setMaxFileSize", "setMaxRequestSize").addParametersMatcher("long").addParametersMatcher("java.lang.String").build());
    private static final MethodMatchers MULTIPART_CONSTRUCTOR = MethodMatchers.create().ofSubTypes("org.springframework.web.multipart.commons.CommonsMultipartResolver", "org.springframework.boot.web.servlet.MultipartConfigFactory").constructor().withAnyParameters().build();
    private static final String DATA_SIZE = "org.springframework.util.unit.DataSize";
    private static final MethodMatchers DATA_SIZE_OF_SOMETHING = MethodMatchers.create().ofSubTypes("org.springframework.util.unit.DataSize").name(name -> name.startsWith("of")).addParametersMatcher("long").build();
    private static final MethodMatchers DATA_SIZE_WITH_UNIT = MethodMatchers.create().ofSubTypes("org.springframework.util.unit.DataSize").names("parse", "of").addParametersMatcher("*", "org.springframework.util.unit.DataUnit").build();
    private static final MethodMatchers DATA_SIZE_PARSE = MethodMatchers.create().ofSubTypes("org.springframework.util.unit.DataSize").names("parse").addParametersMatcher("java.lang.CharSequence").build();
    private final List<AnalyzerMessage> multipartConstructorIssues = new ArrayList<AnalyzerMessage>();
    private boolean sizeSetSomewhere = false;

    @Override
    public void endOfAnalysis() {
        if (!this.sizeSetSomewhere && this.context != null) {
            DefaultJavaFileScannerContext defaultContext = (DefaultJavaFileScannerContext)this.context;
            this.multipartConstructorIssues.forEach(defaultContext::reportIssue);
        }
        this.multipartConstructorIssues.clear();
        this.sizeSetSomewhere = false;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        DefaultJavaFileScannerContext defaultContext = (DefaultJavaFileScannerContext)this.context;
        if (tree.is(Tree.Kind.NEW_CLASS)) {
            NewClassTree newClassTree = (NewClassTree)tree;
            if (MULTIPART_CONSTRUCTOR.matches(newClassTree)) {
                AnalyzerMessage analyzerMessage = defaultContext.createAnalyzerMessage(this, newClassTree, MESSAGE_SIZE_NOT_SET);
                this.multipartConstructorIssues.add(analyzerMessage);
            }
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (METHODS_SETTING_MAX_SIZE.matches(mit)) {
                this.sizeSetSomewhere = true;
                this.getIfExceedSize((ExpressionTree)mit.arguments().get(0)).map(bytesExceeding -> defaultContext.createAnalyzerMessage(this, mit, String.format(MESSAGE_EXCEED_SIZE, bytesExceeding, this.fileUploadSizeLimit))).ifPresent(defaultContext::reportIssue);
            }
        }
    }

    private Optional<Long> getIfExceedSize(ExpressionTree expressionTree) {
        if (expressionTree.is(Tree.Kind.METHOD_INVOCATION)) {
            return ExcessiveContentRequestCheck.getSizeFromDataSize((MethodInvocationTree)expressionTree).filter(b -> b > this.fileUploadSizeLimit);
        }
        return ExcessiveContentRequestCheck.getNumberOfBytes(expressionTree).filter(b -> b > this.fileUploadSizeLimit);
    }

    private static Optional<Long> getSizeFromDataSize(MethodInvocationTree mit) {
        Optional<Long> multiplier;
        if (DATA_SIZE_PARSE.matches(mit)) {
            return ExcessiveContentRequestCheck.getNumberOfBytes((ExpressionTree)mit.arguments().get(0));
        }
        if (DATA_SIZE_OF_SOMETHING.matches(mit)) {
            return ExcessiveContentRequestCheck.getNumberOfBytes((ExpressionTree)mit.arguments().get(0)).map(b -> b * ExcessiveContentRequestCheck.getMultiplierFromName(ExpressionUtils.methodName(mit).name()));
        }
        if (DATA_SIZE_WITH_UNIT.matches(mit) && (multiplier = ExcessiveContentRequestCheck.getIdentifierName((ExpressionTree)mit.arguments().get(1)).map(ExcessiveContentRequestCheck::getMultiplierFromName)).isPresent()) {
            return ExcessiveContentRequestCheck.getNumberOfBytes((ExpressionTree)mit.arguments().get(0)).map(l -> l * (Long)multiplier.get());
        }
        return Optional.empty();
    }

    private static Optional<Long> getNumberOfBytes(ExpressionTree expression) {
        Optional<Integer> integerOptional = expression.asConstant(Integer.class);
        if (integerOptional.isPresent()) {
            return Optional.of(integerOptional.get().longValue());
        }
        Optional<String> stringOptional = expression.asConstant(String.class);
        if (stringOptional.isPresent()) {
            return ExcessiveContentRequestCheck.getLongValueFromString(stringOptional.get());
        }
        return expression.asConstant(Long.class);
    }

    private static Optional<Long> getLongValueFromString(String s) {
        Matcher matcher = DATA_SIZE_PATTERN.matcher(s);
        if (matcher.matches()) {
            return Optional.of(Long.parseLong(matcher.group(1)) * ExcessiveContentRequestCheck.getMultiplierFromName(matcher.group(2)));
        }
        return Optional.empty();
    }

    private static Long getMultiplierFromName(String name) {
        switch (name.toUpperCase(Locale.ENGLISH)) {
            case "OFKILOBYTES": 
            case "KILOBYTES": 
            case "KB": {
                return 1024L;
            }
            case "OFMEGABYTES": 
            case "MEGABYTES": 
            case "MB": {
                return 0x100000L;
            }
            case "OFGIGABYTES": 
            case "GIGABYTES": 
            case "GB": {
                return 0x40000000L;
            }
            case "OFTERABYTES": 
            case "TERABYTES": 
            case "TB": {
                return 0x10000000000L;
            }
        }
        return 1L;
    }

    private static Optional<String> getIdentifierName(ExpressionTree expression) {
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            return Optional.of(((IdentifierTree)expression).name());
        }
        if (expression.is(Tree.Kind.MEMBER_SELECT)) {
            return Optional.of(((MemberSelectExpressionTree)expression).identifier().name());
        }
        return Optional.empty();
    }
}

