/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4507")
public class DebugFeatureEnabledCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make sure this debug feature is deactivated before delivering the code in production.";
    private static final MethodMatchers PRINT_STACK_TRACE_MATCHER = MethodMatchers.create().ofSubTypes("java.lang.Throwable").names("printStackTrace").addWithoutParametersMatcher().build();
    private static final MethodMatchers SET_WEB_CONTENTS_DEBUGGING_ENABLED = MethodMatchers.create().ofSubTypes("android.webkit.WebView", "android.webkit.WebViewFactoryProvider$Statics").names("setWebContentsDebuggingEnabled").addParametersMatcher("boolean").build();
    private final Deque<Symbol.TypeSymbol> enclosingClass = new LinkedList<Symbol.TypeSymbol>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.ANNOTATION, Tree.Kind.CLASS, Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public void visitNode(Tree tree) {
        switch (tree.kind()) {
            case ANNOTATION: {
                this.checkAnnotation((AnnotationTree)tree);
                break;
            }
            case METHOD_INVOCATION: {
                this.checkMethodInvocation((MethodInvocationTree)tree);
                break;
            }
            default: {
                ClassTree classTree = (ClassTree)tree;
                this.enclosingClass.push(classTree.symbol());
            }
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree instanceof ClassTree) {
            this.enclosingClass.pop();
        }
    }

    private void checkMethodInvocation(MethodInvocationTree mit) {
        if (this.isPrintStackTraceIllegalUsage(mit) || DebugFeatureEnabledCheck.isSetWebContentsDebuggingEnabled(mit)) {
            this.reportIssue(ExpressionUtils.methodName(mit), MESSAGE);
        }
    }

    private boolean isPrintStackTraceIllegalUsage(MethodInvocationTree mit) {
        return !this.enclosingClassExtendsThrowable() && PRINT_STACK_TRACE_MATCHER.matches(mit);
    }

    private static boolean isSetWebContentsDebuggingEnabled(MethodInvocationTree mit) {
        return SET_WEB_CONTENTS_DEBUGGING_ENABLED.matches(mit) && Boolean.TRUE.equals(ExpressionUtils.resolveAsConstant((ExpressionTree)mit.arguments().get(0)));
    }

    private void checkAnnotation(AnnotationTree annotation) {
        if (annotation.symbolType().is("org.springframework.security.config.annotation.web.configuration.EnableWebSecurity")) {
            annotation.arguments().stream().map(DebugFeatureEnabledCheck::getDebugArgument).filter(Objects::nonNull).findFirst().filter(assignment -> Boolean.TRUE.equals(ExpressionsHelper.getConstantValueAsBoolean(assignment.expression()).value())).ifPresent(assignment -> this.reportIssue((Tree)assignment, MESSAGE));
        }
    }

    @CheckForNull
    private static AssignmentExpressionTree getDebugArgument(ExpressionTree expression) {
        AssignmentExpressionTree assignment;
        if (expression.is(Tree.Kind.ASSIGNMENT) && (assignment = (AssignmentExpressionTree)expression).variable().is(Tree.Kind.IDENTIFIER) && "debug".equals(((IdentifierTree)assignment.variable()).name())) {
            return assignment;
        }
        return null;
    }

    private boolean enclosingClassExtendsThrowable() {
        return this.enclosingClass.peek() != null && this.enclosingClass.peek().type().isSubtypeOf("java.lang.Throwable");
    }
}

