/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.Symbols;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3329")
public class CipherBlockChainingCheck
extends AbstractMethodDetection {
    private static final MethodMatchers SECURE_RANDOM_GENERATE_SEED = MethodMatchers.create().ofTypes("java.security.SecureRandom").names("generateSeed").withAnyParameters().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes("javax.crypto.spec.IvParameterSpec").constructor().withAnyParameters().build();
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        if (newClassTree.arguments().isEmpty() || CipherBlockChainingCheck.isDynamicallyGenerated((ExpressionTree)newClassTree.arguments().get(0))) {
            return;
        }
        MethodTree mTree = ExpressionUtils.getEnclosingMethod(newClassTree);
        if (mTree != null) {
            MethodInvocationVisitor mitVisit = new MethodInvocationVisitor(newClassTree);
            mTree.accept(mitVisit);
            if (!mitVisit.secureRandomFound) {
                this.reportIssue(newClassTree, "Use a dynamically-generated, random IV.");
            }
        }
    }

    private static boolean isDynamicallyGenerated(ExpressionTree tree) {
        if (tree.is(Tree.Kind.IDENTIFIER)) {
            Symbol symbol = ((IdentifierTree)tree).symbol();
            if (!symbol.isVariableSymbol()) {
                return false;
            }
            VariableTree declaration = ((Symbol.VariableSymbol)symbol).declaration();
            return declaration != null && (CipherBlockChainingCheck.isSecureRandomGenerateSeed(declaration.initializer()) || ReassignmentFinder.getReassignments(declaration, symbol.usages()).stream().map(AssignmentExpressionTree::expression).anyMatch(CipherBlockChainingCheck::isSecureRandomGenerateSeed));
        }
        return CipherBlockChainingCheck.isSecureRandomGenerateSeed(tree);
    }

    private static boolean isSecureRandomGenerateSeed(@Nullable ExpressionTree tree) {
        return tree != null && tree.is(Tree.Kind.METHOD_INVOCATION) && SECURE_RANDOM_GENERATE_SEED.matches((MethodInvocationTree)tree);
    }

    private static class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private boolean secureRandomFound = false;
        private final NewClassTree ivParameterSpecInstantiation;
        private final Symbol ivParameterSymbol;
        private static final MethodMatchers SECURE_RANDOM_NEXT_BYTES = MethodMatchers.create().ofTypes("java.security.SecureRandom").names("nextBytes").withAnyParameters().build();
        private static final MethodMatchers CIPHER_INIT = MethodMatchers.create().ofTypes("javax.crypto.Cipher").names("init").withAnyParameters().build();
        private static final int CIPHER_INIT_DECRYPT_MODE = 2;

        public MethodInvocationVisitor(NewClassTree newClassTree) {
            this.ivParameterSpecInstantiation = newClassTree;
            this.ivParameterSymbol = MethodInvocationVisitor.ivSymbol(newClassTree);
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            int opMode;
            Symbol initVector;
            if (SECURE_RANDOM_NEXT_BYTES.matches(methodInvocation) && !(initVector = MethodInvocationVisitor.symbol((ExpressionTree)this.ivParameterSpecInstantiation.arguments().get(0))).isUnknown() && initVector.equals(MethodInvocationVisitor.symbol((ExpressionTree)methodInvocation.arguments().get(0)))) {
                this.secureRandomFound = true;
            }
            if (CIPHER_INIT.matches(methodInvocation) && methodInvocation.arguments().size() > 2 && 2 == (opMode = ((ExpressionTree)methodInvocation.arguments().get(0)).asConstant(Integer.class).orElse(-1).intValue()) && this.isPartOfArguments(methodInvocation)) {
                this.secureRandomFound = true;
            }
            super.visitMethodInvocation(methodInvocation);
        }

        private boolean isPartOfArguments(MethodInvocationTree methodInvocation) {
            return MethodInvocationVisitor.isPartOfArguments(methodInvocation, this.ivParameterSpecInstantiation) || !this.ivParameterSymbol.isUnknown() && MethodInvocationVisitor.isPartOfArguments(methodInvocation, this.ivParameterSymbol);
        }

        private static boolean isPartOfArguments(MethodInvocationTree methodInvocation, ExpressionTree ivParameter) {
            return methodInvocation.arguments().stream().map(ExpressionUtils::skipParentheses).anyMatch(ivParameter::equals);
        }

        private static boolean isPartOfArguments(MethodInvocationTree methodInvocation, Symbol ivParameterSymbol) {
            return methodInvocation.arguments().stream().map(ExpressionUtils::skipParentheses).map(MethodInvocationVisitor::symbol).anyMatch(ivParameterSymbol::equals);
        }

        private static Symbol symbol(ExpressionTree expression) {
            if (expression.is(Tree.Kind.IDENTIFIER)) {
                return ((IdentifierTree)expression).symbol();
            }
            if (expression.is(Tree.Kind.MEMBER_SELECT)) {
                return ((MemberSelectExpressionTree)expression).identifier().symbol();
            }
            return Symbols.unknownSymbol;
        }

        private static Symbol ivSymbol(NewClassTree newClassTree) {
            Tree parent = newClassTree.parent();
            if (parent.is(Tree.Kind.VARIABLE)) {
                return ((VariableTree)parent).symbol();
            }
            return Symbols.unknownSymbol;
        }
    }
}

