/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6288")
public class AndroidNonAuthenticatedUsersCheck
extends AbstractMethodDetection {
    private static final String KEY_GEN_PARAMETER_SPEC_BUILDER_TYPE = "android.security.keystore.KeyGenParameterSpec$Builder";
    private static final MethodMatchers KEY_GEN_BUILDER_BUILD = MethodMatchers.create().ofTypes("android.security.keystore.KeyGenParameterSpec$Builder").names("build").addWithoutParametersMatcher().build();
    private static final MethodMatchers KEY_GEN_BUILDER_SET_AUTH_MATCHER = MethodMatchers.create().ofTypes("android.security.keystore.KeyGenParameterSpec$Builder").names("setUserAuthenticationRequired").addParametersMatcher("boolean").build();
    private static final MethodMatchers KEY_GEN_BUILDER = MethodMatchers.create().ofTypes("android.security.keystore.KeyGenParameterSpec$Builder").constructor().withAnyParameters().build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return KEY_GEN_BUILDER_BUILD;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        AndroidNonAuthenticatedUsersCheck.getNotAuthenticatedConstructor(mit.methodSelect()).ifPresent(newClassTree -> this.reportIssue(newClassTree.identifier(), "Make sure authorizing non-authenticated users to use this key is safe here."));
    }

    private static Optional<NewClassTree> getNotAuthenticatedConstructor(ExpressionTree expression) {
        if (expression.is(Tree.Kind.MEMBER_SELECT)) {
            expression = ((MemberSelectExpressionTree)expression).expression();
        }
        if (expression.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree mit = (MethodInvocationTree)expression;
            if (!AndroidNonAuthenticatedUsersCheck.authenticate(mit)) {
                return AndroidNonAuthenticatedUsersCheck.getNotAuthenticatedConstructor(mit.methodSelect());
            }
        } else {
            NewClassTree newClassTree;
            if (expression.is(Tree.Kind.IDENTIFIER)) {
                Symbol symbol = ((IdentifierTree)expression).symbol();
                if (symbol.usages().stream().anyMatch(AndroidNonAuthenticatedUsersCheck::canAuthenticate)) {
                    return Optional.empty();
                }
                return AndroidNonAuthenticatedUsersCheck.getNotAuthenticatedConstructorInDeclaration(symbol);
            }
            if (expression.is(Tree.Kind.NEW_CLASS) && KEY_GEN_BUILDER.matches(newClassTree = (NewClassTree)expression)) {
                return Optional.of(newClassTree);
            }
        }
        return Optional.empty();
    }

    private static Optional<NewClassTree> getNotAuthenticatedConstructorInDeclaration(Symbol symbol) {
        ExpressionTree initializer;
        Tree declaration;
        if (JUtils.isLocalVariable(symbol) && (declaration = symbol.declaration()) instanceof VariableTree && (initializer = ((VariableTree)declaration).initializer()) != null) {
            return AndroidNonAuthenticatedUsersCheck.getNotAuthenticatedConstructor(initializer);
        }
        return Optional.empty();
    }

    private static boolean canAuthenticate(IdentifierTree tokenIdentifier) {
        Tree parent = tokenIdentifier.parent();
        if (parent != null && parent.is(Tree.Kind.ARGUMENTS)) {
            return true;
        }
        Optional<MethodInvocationTree> subsequentInvocation = MethodTreeUtils.subsequentMethodInvocation(tokenIdentifier, KEY_GEN_BUILDER_SET_AUTH_MATCHER);
        return subsequentInvocation.isPresent() && LiteralUtils.isTrue((Tree)subsequentInvocation.get().arguments().get(0));
    }

    private static boolean authenticate(MethodInvocationTree mit) {
        return KEY_GEN_BUILDER_SET_AUTH_MATCHER.matches(mit) && LiteralUtils.isTrue((Tree)mit.arguments().get(0));
    }
}

