/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.WildcardTree;

@Rule(key="S1452")
public class WildcardReturnParameterTypeCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (!WildcardReturnParameterTypeCheck.isPrivate(methodTree) && WildcardReturnParameterTypeCheck.isNotOverriding(methodTree)) {
            methodTree.returnType().accept(new CheckWildcard());
        }
    }

    private static boolean isPrivate(MethodTree methodTree) {
        return ModifiersUtils.hasModifier(methodTree.modifiers(), Modifier.PRIVATE);
    }

    private static boolean isNotOverriding(MethodTree tree) {
        return Boolean.FALSE.equals(tree.isOverriding());
    }

    private class CheckWildcard
    extends BaseTreeVisitor {
        private CheckWildcard() {
        }

        @Override
        public void visitParameterizedType(ParameterizedTypeTree tree) {
            Type symbolType = tree.type().symbolType();
            TypeArguments typeArguments = tree.typeArguments();
            if (typeArguments.size() == 3 && symbolType.is("java.util.stream.Collector")) {
                this.reportIfWildcard((Tree)typeArguments.get(0));
                this.reportIfWildcard((Tree)typeArguments.get(2));
            } else if (!symbolType.is("java.lang.Class") && !symbolType.isUnknown()) {
                typeArguments.forEach(this::reportIfWildcard);
            }
            super.visitParameterizedType(tree);
        }

        private void reportIfWildcard(Tree tree) {
            if (tree.is(Tree.Kind.EXTENDS_WILDCARD, Tree.Kind.UNBOUNDED_WILDCARD, Tree.Kind.SUPER_WILDCARD)) {
                WildcardReturnParameterTypeCheck.this.reportIssue(((WildcardTree)tree).queryToken(), "Remove usage of generic wildcard type.");
            }
        }
    }
}

