/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInSynchronizeChecker;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2273")
public class WaitInSynchronizeCheck
extends AbstractInSynchronizeChecker {
    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!this.isInSyncBlock()) {
            IdentifierTree methodName = ExpressionUtils.methodName(mit);
            ExpressionTree methodSelect = mit.methodSelect();
            String lockName = methodSelect.is(Tree.Kind.MEMBER_SELECT) ? ((MemberSelectExpressionTree)methodSelect).expression().symbolType().name() : "this";
            this.reportIssue(methodName, "Move this call to \"" + methodName + "()\" into a synchronized block to be sure the monitor on \"" + lockName + "\" is held.");
        }
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofAnyType().names("wait").addWithoutParametersMatcher().addParametersMatcher("long").addParametersMatcher("long", "int").build(), MethodMatchers.create().ofAnyType().names("notify", "notifyAll").addWithoutParametersMatcher().build());
    }
}

