/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AssertStatementTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="S00122", repositoryKey="squid")
@Rule(key="S122")
public class TooManyStatementsPerLineCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR, Tree.Kind.STATIC_INITIALIZER, Tree.Kind.INITIALIZER);
    }

    @Override
    public void visitNode(Tree tree) {
        BlockTree block = tree.is(Tree.Kind.STATIC_INITIALIZER, Tree.Kind.INITIALIZER) ? (BlockTree)tree : ((MethodTree)tree).block();
        if (block != null) {
            StatementVisitor visitor = new StatementVisitor();
            block.accept(visitor);
            visitor.statementsPerLine.forEach((line, count) -> {
                if (count > 1) {
                    this.addIssue((int)line, "At most one statement is allowed per line, but " + count + " statements were found on this line.");
                }
            });
        }
    }

    private static class StatementVisitor
    extends BaseTreeVisitor {
        private final Map<Integer, Integer> statementsPerLine = new HashMap<Integer, Integer>();

        private StatementVisitor() {
        }

        @Override
        public void visitClass(ClassTree tree) {
        }

        @Override
        public void visitAssertStatement(AssertStatementTree tree) {
            this.addLines(tree.assertKeyword(), tree.semicolonToken());
        }

        @Override
        public void visitBreakStatement(BreakStatementTree tree) {
            this.addLines(tree.breakKeyword(), tree.semicolonToken());
        }

        @Override
        public void visitContinueStatement(ContinueStatementTree tree) {
            this.addLines(tree.continueKeyword(), tree.semicolonToken());
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree tree) {
            this.addLines(tree.returnKeyword(), tree.semicolonToken());
        }

        @Override
        public void visitThrowStatement(ThrowStatementTree tree) {
            this.addLines(tree.throwKeyword(), tree.semicolonToken());
        }

        @Override
        public void visitExpressionStatement(ExpressionStatementTree tree) {
            SyntaxToken firstToken = tree.firstToken();
            if (firstToken != null) {
                this.addLines(firstToken, tree.semicolonToken());
            } else {
                this.addLine(tree.semicolonToken());
            }
        }

        @Override
        public void visitIfStatement(IfStatementTree tree) {
            this.addLine(tree.ifKeyword());
            StatementTree thenStatement = tree.thenStatement();
            StatementTree elseStatement = tree.elseStatement();
            this.scan(thenStatement);
            this.scan(elseStatement);
            if (elseStatement == null) {
                this.addLineOfCloseBrace(tree.ifKeyword(), thenStatement);
            } else {
                this.addLineOfCloseBrace(tree.ifKeyword(), elseStatement);
            }
        }

        private void addLineOfCloseBrace(SyntaxToken startToken, StatementTree tree) {
            if (tree.is(Tree.Kind.BLOCK)) {
                SyntaxToken closeBraceToken = ((BlockTree)tree).closeBraceToken();
                if (startToken.range().start().line() != closeBraceToken.range().start().line() && !this.statementsPerLine.containsKey(closeBraceToken.range().start().line())) {
                    this.addLine(closeBraceToken);
                }
            }
        }

        @Override
        public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
            this.addLine(tree.synchronizedKeyword());
            this.addLineOfCloseBrace(tree.synchronizedKeyword(), tree.block());
            this.scan(tree.block());
        }

        @Override
        public void visitSwitchStatement(SwitchStatementTree tree) {
            this.addLines(tree.switchKeyword(), tree.openBraceToken());
            this.scan(tree.cases());
            this.addLine(tree.closeBraceToken());
        }

        @Override
        public void visitVariable(VariableTree tree) {
            SyntaxToken endToken = tree.endToken();
            if (endToken != null && ";".equals(endToken.text())) {
                this.addLine(endToken);
            }
        }

        @Override
        public void visitWhileStatement(WhileStatementTree tree) {
            this.addLines(tree.whileKeyword(), tree.closeParenToken());
            this.addLineOfCloseBrace(tree.whileKeyword(), tree.statement());
            this.scan(tree.statement());
        }

        @Override
        public void visitDoWhileStatement(DoWhileStatementTree tree) {
            this.addLine(tree.doKeyword());
            if (tree.doKeyword().range().start().line() != tree.whileKeyword().range().start().line()) {
                this.addLines(tree.whileKeyword(), tree.semicolonToken());
            }
            this.scan(tree.statement());
        }

        @Override
        public void visitForStatement(ForStatementTree tree) {
            this.addLines(tree.forKeyword(), tree.closeParenToken());
            this.addLineOfCloseBrace(tree.forKeyword(), tree.statement());
            this.scan(tree.statement());
        }

        @Override
        public void visitForEachStatement(ForEachStatement tree) {
            this.addLines(tree.forKeyword(), tree.closeParenToken());
            this.addLineOfCloseBrace(tree.forKeyword(), tree.statement());
            this.scan(tree.statement());
        }

        @Override
        public void visitTryStatement(TryStatementTree tree) {
            if (tree.resourceList().isEmpty()) {
                this.addLine(tree.tryKeyword());
            } else {
                this.addLines(tree.tryKeyword(), tree.closeParenToken());
            }
            this.scan(tree.block());
            this.scan(tree.catches());
            if (tree.finallyKeyword() != null) {
                this.addLine(tree.finallyKeyword());
            }
            this.scan(tree.finallyBlock());
        }

        private void addLine(SyntaxToken token) {
            this.statementsPerLine.compute(token.range().start().line(), (k, v) -> v == null ? 1 : v + 1);
        }

        private void addLines(SyntaxToken startToken, SyntaxToken endToken) {
            this.addLine(startToken);
            if (startToken.range().start().line() != endToken.range().start().line()) {
                this.addLine(endToken);
            }
        }
    }
}

