/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S5164")
public class ThreadLocalCleanupCheck
extends IssuableSubscriptionVisitor {
    private static final String THREAD_LOCAL = "java.lang.ThreadLocal";
    private static final MethodMatchers THREADLOCAL_SET = MethodMatchers.create().ofTypes("java.lang.ThreadLocal").names("set").addParametersMatcher("*").build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.CLASS)) {
            Symbol.TypeSymbol clazz = ((ClassTree)tree).symbol();
            Type superClass = clazz.superClass();
            if (clazz.type().isSubtypeOf(THREAD_LOCAL) || superClass != null && superClass.isUnknown()) {
                return;
            }
            clazz.memberSymbols().stream().filter(Symbol::isVariableSymbol).filter(s -> s.isPrivate() && s.type().is(THREAD_LOCAL)).forEach(this::checkThreadLocalField);
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (THREADLOCAL_SET.matches(mit) && ((ExpressionTree)mit.arguments().get(0)).is(Tree.Kind.NULL_LITERAL)) {
                ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(mit).withMessage("Use \"remove()\" instead of \"set(null)\".").withQuickFix(() -> JavaQuickFix.newQuickFix("Replace with \"remove()\"").addTextEdit(JavaTextEdit.replaceBetweenTree(ExpressionUtils.methodName(mit), mit.arguments(), "remove()")).build())).report();
            }
        }
    }

    private void checkThreadLocalField(Symbol field) {
        if (field.usages().stream().noneMatch(ThreadLocalCleanupCheck::usageIsRemove)) {
            this.reportIssue(((VariableTree)field.declaration()).simpleName(), "Call \"remove()\" on \"" + field.name() + "\".");
        }
    }

    private static boolean usageIsRemove(IdentifierTree usage) {
        return MethodTreeUtils.consecutiveMethodInvocation(usage).filter(mit -> ExpressionUtils.methodName(mit).name().equals("remove")).isPresent();
    }
}

