/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S4266")
public class RedundantStreamCollectCheck
extends AbstractMethodDetection {
    private static final String[] STREAM_TYPES = new String[]{"java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream"};
    private static final MethodMatchers COUNTING = RedundantStreamCollectCheck.streamCollectorsMatcher().names("counting").addWithoutParametersMatcher().build();
    private static final MethodMatchers MAX_BY = RedundantStreamCollectCheck.streamCollectorsMatcher().names("maxBy").withAnyParameters().build();
    private static final MethodMatchers MIN_BY = RedundantStreamCollectCheck.streamCollectorsMatcher().names("minBy").withAnyParameters().build();
    private static final MethodMatchers MAPPING = RedundantStreamCollectCheck.streamCollectorsMatcher().names("mapping").withAnyParameters().build();
    private static final MethodMatchers REDUCING = RedundantStreamCollectCheck.streamCollectorsMatcher().names("reducing").withAnyParameters().build();
    private static final MethodMatchers SUMMING_INT = RedundantStreamCollectCheck.streamCollectorsMatcher().names("summingInt").withAnyParameters().build();
    private static final MethodMatchers SUMMING_LONG = RedundantStreamCollectCheck.streamCollectorsMatcher().names("summingLong").withAnyParameters().build();
    private static final MethodMatchers SUMMING_DOUBLE = RedundantStreamCollectCheck.streamCollectorsMatcher().names("summingDouble").withAnyParameters().build();
    private static final Map<MethodMatchers, String> REPLACEMENTS = MapBuilder.newMap().put(COUNTING, "count()").put(MAX_BY, "max()").put(MIN_BY, "min()").put(MAPPING, "map(...).collect()").put(REDUCING, "reduce(...).collect()").put(SUMMING_INT, "mapToInt(...).sum()").put(SUMMING_LONG, "mapToLong(...).sum()").put(SUMMING_DOUBLE, "mapToDouble(...).sum()").build();

    private static MethodMatchers.NameBuilder streamCollectorsMatcher() {
        return MethodMatchers.create().ofTypes("java.util.stream.Collectors");
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(STREAM_TYPES).names("collect").addParametersMatcher("java.util.stream.Collector").build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree collectMIT) {
        ExpressionTree argument = (ExpressionTree)collectMIT.arguments().get(0);
        if (argument.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)argument;
            REPLACEMENTS.entrySet().stream().filter(e -> ((MethodMatchers)e.getKey()).matches(methodInvocation)).findFirst().ifPresent(e -> this.context.reportIssue(this, ExpressionUtils.methodName(methodInvocation), "Use \"" + (String)e.getValue() + "\" instead."));
        }
    }
}

