/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.ListUtils;

@Rule(key="S2211")
public class LambdaTypeParameterCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.LAMBDA_EXPRESSION);
    }

    @Override
    public void visitNode(Tree tree) {
        LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)tree;
        List<VariableTree> parameters = lambdaExpressionTree.parameters();
        if (parameters.size() <= 2 && !lambdaExpressionTree.body().is(Tree.Kind.BLOCK)) {
            return;
        }
        String missingTypeParameters = parameters.stream().filter(variable -> variable.type().is(Tree.Kind.INFERED_TYPE)).map(VariableTree::simpleName).map(IdentifierTree::name).map(parameterName -> "'" + parameterName + "'").collect(Collectors.joining(", "));
        if (!missingTypeParameters.isEmpty()) {
            this.reportIssue(parameters.get(0), ListUtils.getLast(parameters), String.format("Specify a type for: %s", missingTypeParameters));
        }
    }
}

