/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4454")
public class EqualsParametersMarkedNonNullCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (!MethodTreeUtils.isEqualsMethod(methodTree)) {
            return;
        }
        VariableTree variable = methodTree.parameters().get(0);
        SymbolMetadata.NullabilityData nullabilityData = variable.symbol().metadata().nullabilityData();
        SymbolMetadata.AnnotationInstance annotation = nullabilityData.annotation();
        Tree annotationTree = nullabilityData.declaration();
        if (annotationTree != null && annotation != null && nullabilityData.isNonNull(SymbolMetadata.NullabilityLevel.VARIABLE, true, false)) {
            String annotationName = annotation.symbol().name();
            ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(annotationTree).withMessage("\"equals\" method parameters should not be marked \"@%s\".", annotationName).withQuickFix(() -> JavaQuickFix.newQuickFix("Remove \"@%s\"", annotationName).addTextEdit(JavaTextEdit.removeTextSpan(AnalyzerMessage.textSpanBetween(annotationTree, true, QuickFixHelper.nextToken(annotationTree), false))).build())).report();
        }
    }
}

