/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractMissingDeprecatedChecker;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6355")
public class DeprecatedArgumentsCheck
extends AbstractMissingDeprecatedChecker {
    private boolean isJava9 = false;

    @Override
    public void setContext(JavaFileScannerContext context) {
        this.isJava9 = context.getJavaVersion().isJava9Compatible();
        super.setContext(context);
    }

    @Override
    void handleDeprecatedElement(Tree tree, @CheckForNull AnnotationTree deprecatedAnnotation, boolean hasJavadocDeprecatedTag) {
        if (this.isJava9 && deprecatedAnnotation != null && deprecatedAnnotation.arguments().isEmpty()) {
            this.reportIssue(deprecatedAnnotation, "Add 'since' and/or 'forRemoval' arguments to the @Deprecated annotation.");
        }
    }
}

