/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.se.NullabilityDataUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2638")
public class ChangeMethodContractCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        List<Symbol.MethodSymbol> overriddenSymbols = methodSymbol.overriddenSymbols();
        if (overriddenSymbols.isEmpty()) {
            return;
        }
        Symbol.MethodSymbol overridee = overriddenSymbols.get(0);
        if (overridee.isMethodSymbol()) {
            this.checkContractChange(methodTree, overridee);
        }
    }

    private void checkContractChange(MethodTree methodTree, Symbol.MethodSymbol overridee) {
        SymbolMetadata.NullabilityData methodNullability;
        if (MethodTreeUtils.isEqualsMethod(methodTree)) {
            return;
        }
        for (int i = 0; i < methodTree.parameters().size(); ++i) {
            VariableTree parameter = methodTree.parameters().get(i);
            this.checkParameter(parameter, JUtils.parameterAnnotations(overridee, i));
        }
        SymbolMetadata.NullabilityData overrideeNullability = overridee.metadata().nullabilityData();
        if (overrideeNullability.isNonNull(SymbolMetadata.NullabilityLevel.PACKAGE, false, false) && (methodNullability = methodTree.symbol().metadata().nullabilityData()).isNullable(SymbolMetadata.NullabilityLevel.PACKAGE, false, false)) {
            this.reportIssue((Tree)methodTree.returnType(), overrideeNullability, methodNullability);
        }
    }

    private void checkParameter(VariableTree parameter, SymbolMetadata overrideeParamMetadata) {
        SymbolMetadata.NullabilityData paramNullability;
        SymbolMetadata.NullabilityData overrideeParamNullability = overrideeParamMetadata.nullabilityData();
        if (overrideeParamNullability.isNullable(SymbolMetadata.NullabilityLevel.PACKAGE, false, false) && (paramNullability = parameter.symbol().metadata().nullabilityData()).isNonNull(SymbolMetadata.NullabilityLevel.PACKAGE, false, false)) {
            this.reportIssue((Tree)parameter.simpleName(), overrideeParamNullability, paramNullability);
        }
    }

    private void reportIssue(Tree reportLocation, SymbolMetadata.NullabilityData overrideeNullability, SymbolMetadata.NullabilityData otherNullability) {
        Optional<String> overrideeAsString = NullabilityDataUtils.nullabilityAsString(otherNullability);
        Optional<String> otherAsString = NullabilityDataUtils.nullabilityAsString(overrideeNullability);
        if (overrideeAsString.isPresent() && otherAsString.isPresent()) {
            this.reportIssue(reportLocation, String.format("Fix the incompatibility of the annotation %s to honor %s of the overridden method.", overrideeAsString.get(), otherAsString.get()), ChangeMethodContractCheck.getSecondariesForAnnotations(otherNullability, overrideeNullability), null);
        }
    }

    private static List<JavaFileScannerContext.Location> getSecondariesForAnnotations(SymbolMetadata.NullabilityData childData, SymbolMetadata.NullabilityData parentData) {
        Tree parentDeclaration;
        ArrayList<JavaFileScannerContext.Location> secondaries = new ArrayList<JavaFileScannerContext.Location>();
        Tree childDeclaration = childData.declaration();
        if (childDeclaration != null) {
            secondaries.add(new JavaFileScannerContext.Location("Child annotation", childDeclaration));
        }
        if ((parentDeclaration = parentData.declaration()) != null) {
            secondaries.add(new JavaFileScannerContext.Location("Overridden annotation", parentDeclaration));
        }
        return secondaries;
    }
}

