/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S1940")
public class BooleanInversionCheck
extends IssuableSubscriptionVisitor {
    private static final Map<String, String> OPERATORS = MapBuilder.newMap().put("==", "!=").put("!=", "==").put("<", ">=").put(">", "<=").put("<=", ">").put(">=", "<").build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.LOGICAL_COMPLEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        ExpressionTree expression = ExpressionUtils.skipParentheses(((UnaryExpressionTree)tree).expression());
        if (expression.is(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN_OR_EQUAL_TO)) {
            this.context.reportIssue(this, tree, "Use the opposite operator (\"" + OPERATORS.get(((BinaryExpressionTree)expression).operatorToken().text()) + "\") instead.");
        }
    }
}

