/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.tree.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.iac.terraform.api.tree.SeparatedTrees;
import org.sonar.iac.terraform.api.tree.SyntaxToken;
import org.sonar.iac.terraform.api.tree.TerraformTree;

public class SeparatedTreesImpl<T extends TerraformTree>
implements SeparatedTrees<T> {
    private final List<T> trees;
    private final List<SyntaxToken> separators;
    private final List<TerraformTree> elementsAndSeparators;

    public SeparatedTreesImpl(List<T> trees, List<SyntaxToken> separators) {
        if (trees.size() != separators.size() + 1 && trees.size() != separators.size()) {
            throw new IllegalArgumentException(String.format("Instantiating SeparatedTrees with inconsistent number of elements (%s) and separators (%s)", trees.size(), separators.size()));
        }
        this.trees = trees;
        this.separators = separators;
        this.elementsAndSeparators = new ArrayList<TerraformTree>();
        int separatorsSize = separators.size();
        for (int i = 0; i < trees.size(); ++i) {
            this.elementsAndSeparators.add((TerraformTree)trees.get(i));
            if (i >= separatorsSize) continue;
            this.elementsAndSeparators.add(separators.get(i));
        }
    }

    public static <T extends TerraformTree> SeparatedTreesImpl<T> empty() {
        return new SeparatedTreesImpl(Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public List<T> trees() {
        return this.trees;
    }

    @Override
    public List<SyntaxToken> separators() {
        return this.separators;
    }

    @Override
    public List<TerraformTree> treesAndSeparators() {
        return this.elementsAndSeparators;
    }
}

