/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.TupleTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;
import org.sonar.iac.terraform.checks.azure.helper.RoleScopeHelper;

@Rule(key="S6385")
public class SubscriptionOwnerCapabilitiesCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Narrow the actions or assignable scope of this custom role.";
    private static final Predicate<String> REFERENCE_SCOPE_PREDICATE = RoleScopeHelper.matchPredicate("data\\.azurerm_subscription\\.[^.]*(primary|current)[^.]*\\.id|data\\.azurerm_management_group\\.[^.]*(parent|root)[^.]*\\.id");
    private static final Predicate<String> PLAIN_SCOPE_PREDICATE = RoleScopeHelper.matchPredicate("^/subscriptions/[^/]+/?$|^/providers/microsoft\\.management/.+");

    @Override
    protected void registerResourceChecks() {
        this.register(SubscriptionOwnerCapabilitiesCheck::checkRoleDefinition, "azurerm_role_definition");
    }

    private static void checkRoleDefinition(CheckContext ctx, BlockTree resource) {
        if (SubscriptionOwnerCapabilitiesCheck.hasOwnerPermission(resource) && SubscriptionOwnerCapabilitiesCheck.hasSensitiveScope(resource)) {
            SubscriptionOwnerCapabilitiesCheck.reportResource(ctx, resource, MESSAGE);
        }
    }

    private static boolean hasSensitiveScope(BlockTree resource) {
        return PropertyUtils.value(resource, "assignable_scopes", TupleTree.class).filter(scopes -> scopes.elements().trees().stream().anyMatch(scope -> SubscriptionOwnerCapabilitiesCheck.isSensitiveScope(scope))).isPresent();
    }

    private static boolean isSensitiveScope(ExpressionTree scope) {
        return RoleScopeHelper.isSensitiveScope(scope, REFERENCE_SCOPE_PREDICATE, PLAIN_SCOPE_PREDICATE);
    }

    private static boolean hasOwnerPermission(BlockTree resource) {
        return PropertyUtils.get(resource, "permissions", BlockTree.class).flatMap(permissions -> PropertyUtils.value(permissions, "actions", TupleTree.class)).filter(SubscriptionOwnerCapabilitiesCheck::allowAllAction).isPresent();
    }

    private static boolean allowAllAction(TupleTree actions) {
        return actions.elements().trees().stream().anyMatch(action -> TextUtils.isValue(action, "*").isTrue());
    }
}

