/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.TupleTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;
import org.sonar.iac.terraform.checks.IpRestrictedAdminAccessCheck;

public class AzureIpRestrictedAdminAccessCheckPart
extends AbstractResourceCheck {
    private static final Pattern PORT_RANGE_PATTERN = Pattern.compile("^(?<from>\\d{1,5})-(?<to>\\d{1,5})$");
    private static final Set<String> SENSITIVE_PORTS = Set.of("*", String.valueOf(22), String.valueOf(3389));
    private static final Set<String> SENSITIVE_PREFIXES = Set.of("*", "0.0.0.0/0", "::/0");

    @Override
    protected void registerResourceChecks() {
        this.register(AzureIpRestrictedAdminAccessCheckPart::checkNetworkSecurityGroup, "azurerm_network_security_group");
        this.register(AzureIpRestrictedAdminAccessCheckPart::checkNetworkSecurityRule, "azurerm_network_security_rule");
    }

    public static void checkNetworkSecurityGroup(CheckContext ctx, BlockTree resource) {
        PropertyUtils.getAll(resource, "security_rule", BlockTree.class).forEach(rule -> AzureIpRestrictedAdminAccessCheckPart.checkNetworkSecurityRule(ctx, rule));
    }

    private static void checkNetworkSecurityRule(CheckContext ctx, BlockTree rule) {
        if (AzureIpRestrictedAdminAccessCheckPart.hasAttributeWithMatchingValue(rule, "direction", "Inbound"::equals) && AzureIpRestrictedAdminAccessCheckPart.hasAttributeWithMatchingValue(rule, "access", "Allow"::equals) && AzureIpRestrictedAdminAccessCheckPart.hasAttributeWithMatchingValue(rule, "protocol", p -> "Tcp".equals(p) || "*".equals(p))) {
            AzureIpRestrictedAdminAccessCheckPart.checkSecurityRule(ctx, rule);
        }
    }

    private static void checkSecurityRule(CheckContext ctx, BlockTree rule) {
        AzureIpRestrictedAdminAccessCheckPart.sensitiveDestinationPortRange(rule).ifPresent(sensitivePort -> AzureIpRestrictedAdminAccessCheckPart.sensitiveSourcePrefix(rule).ifPresent(sensitivePrefix -> ctx.reportIssue((HasTextRange)sensitivePrefix, "Restrict IP addresses authorized to access administration services.", new SecondaryLocation((HasTextRange)sensitivePort, "Related protocol setting."))));
    }

    private static Optional<ExpressionTree> sensitiveDestinationPortRange(BlockTree rule) {
        Predicate<ExpressionTree> rangeContainsSensitivePort = range -> TextUtils.getValue(range).filter(AzureIpRestrictedAdminAccessCheckPart::rangeContainsSensitivePort).isPresent();
        return PropertyUtils.get(rule, "destination_port_range", AttributeTree.class).map(AttributeTree::value).filter(rangeContainsSensitivePort).or(() -> AzureIpRestrictedAdminAccessCheckPart.expressionInAttributeTuple(rule, "destination_port_ranges", rangeContainsSensitivePort));
    }

    private static Optional<ExpressionTree> sensitiveSourcePrefix(BlockTree rule) {
        Predicate<ExpressionTree> isSensitivePrefix = prefixExpression -> TextUtils.matchesValue(prefixExpression, SENSITIVE_PREFIXES::contains).isTrue();
        return PropertyUtils.get(rule, "source_address_prefix", AttributeTree.class).map(AttributeTree::value).filter(isSensitivePrefix).or(() -> AzureIpRestrictedAdminAccessCheckPart.expressionInAttributeTuple(rule, "source_address_prefixes", isSensitivePrefix));
    }

    private static Optional<ExpressionTree> expressionInAttributeTuple(BlockTree block, String attribute, Predicate<ExpressionTree> predicate) {
        return PropertyUtils.get(block, attribute, AttributeTree.class).map(AttributeTree::value).filter(TupleTree.class::isInstance).map(TupleTree.class::cast).flatMap(tupleTree -> tupleTree.elements().trees().stream().filter(predicate).findFirst());
    }

    private static boolean hasAttributeWithMatchingValue(BlockTree rule, String attribute, Predicate<String> stringPredicate) {
        return PropertyUtils.get(rule, attribute, AttributeTree.class).filter(attr -> TextUtils.matchesValue(attr.value(), stringPredicate).isTrue()).isPresent();
    }

    private static boolean rangeContainsSensitivePort(String range) {
        if (range.contains("-")) {
            Matcher m = PORT_RANGE_PATTERN.matcher(range);
            if (m.find()) {
                return IpRestrictedAdminAccessCheck.rangeContainsSshOrRdpPort(AzureIpRestrictedAdminAccessCheckPart.portFromMatch(m, "from"), AzureIpRestrictedAdminAccessCheckPart.portFromMatch(m, "to"));
            }
            return false;
        }
        return SENSITIVE_PORTS.contains(range);
    }

    private static int portFromMatch(Matcher m, String group) {
        return Integer.parseInt(m.group(group));
    }
}

