/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.aws;

import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

public class AwsWeakSSLProtocolCheckPart
extends AbstractResourceCheck {
    private static final String STRONG_SSL_PROTOCOL = "TLS_1_2";
    private static final String ELASTIC_STRONG_POLICY = "Policy-Min-TLS-1-2-2019-07";
    private static final String SECURITY_POLICY = "security_policy";

    @Override
    protected void registerResourceChecks() {
        this.register(AwsWeakSSLProtocolCheckPart::checkApiGatewayDomainName, "aws_api_gateway_domain_name");
        this.register(AwsWeakSSLProtocolCheckPart::checkApiGatewayV2DomainName, "aws_apigatewayv2_domain_name");
        this.register(AwsWeakSSLProtocolCheckPart::checkElasticsearchDomain, "aws_elasticsearch_domain");
    }

    private static void checkApiGatewayDomainName(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, SECURITY_POLICY, AttributeTree.class).ifPresentOrElse(policy -> AwsWeakSSLProtocolCheckPart.reportUnexpectedValue(ctx, policy, STRONG_SSL_PROTOCOL, "Change this configuration to use a stronger protocol.", new SecondaryLocation[0]), () -> AwsWeakSSLProtocolCheckPart.reportResource(ctx, resource, String.format("Omitting %s disables traffic encryption. Make sure it is safe here.", SECURITY_POLICY)));
    }

    private static void checkApiGatewayV2DomainName(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "domain_name_configuration", BlockTree.class).ifPresentOrElse(config -> AwsWeakSSLProtocolCheckPart.checkDomainNameConfiguration(ctx, config), () -> AwsWeakSSLProtocolCheckPart.reportResource(ctx, resource, String.format("Omitting %s disables traffic encryption. Make sure it is safe here.", "domain_name_configuration.security_policy")));
    }

    private static void checkElasticsearchDomain(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "domain_endpoint_options", BlockTree.class).ifPresentOrElse(options -> AwsWeakSSLProtocolCheckPart.checkDomainEndpointOptions(ctx, options), () -> AwsWeakSSLProtocolCheckPart.reportResource(ctx, resource, String.format("Omitting %s disables traffic encryption. Make sure it is safe here.", "domain_endpoint_options.tls_security_policy")));
    }

    private static void checkDomainNameConfiguration(CheckContext ctx, BlockTree config) {
        PropertyUtils.get(config, SECURITY_POLICY, AttributeTree.class).ifPresentOrElse(policy -> AwsWeakSSLProtocolCheckPart.reportUnexpectedValue(ctx, policy, STRONG_SSL_PROTOCOL, "Change this configuration to use a stronger protocol.", new SecondaryLocation[0]), () -> ctx.reportIssue(config.key(), String.format("Omitting %s disables traffic encryption. Make sure it is safe here.", SECURITY_POLICY)));
    }

    private static void checkDomainEndpointOptions(CheckContext ctx, BlockTree options) {
        PropertyUtils.get(options, "tls_security_policy", AttributeTree.class).ifPresentOrElse(policy -> AwsWeakSSLProtocolCheckPart.reportUnexpectedValue(ctx, policy, ELASTIC_STRONG_POLICY, "Change this configuration to use a stronger protocol.", new SecondaryLocation[0]), () -> ctx.reportIssue(options.key(), String.format("Omitting %s disables traffic encryption. Make sure it is safe here.", "tls_security_policy")));
    }
}

