/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.terraform.checks.aws.AwsIpRestrictedAdminAccessCheckPart;
import org.sonar.iac.terraform.checks.azure.AzureIpRestrictedAdminAccessCheckPart;

@Rule(key="S6321")
public class IpRestrictedAdminAccessCheck
implements IacCheck {
    public static final String MESSAGE = "Restrict IP addresses authorized to access administration services.";
    public static final String SECONDARY_MSG = "Related protocol setting.";
    public static final String ALL_IPV4 = "0.0.0.0/0";
    public static final String ALL_IPV6 = "::/0";
    public static final int SSH_PORT = 22;
    public static final int RDP_PORT = 3389;

    @Override
    public void initialize(InitContext init) {
        new AwsIpRestrictedAdminAccessCheckPart().initialize(init);
        new AzureIpRestrictedAdminAccessCheckPart().initialize(init);
    }

    public static boolean rangeContainsSshOrRdpPort(int from, int to) {
        return 22 >= from && 22 <= to || 3389 >= from && 3389 <= to;
    }
}

