/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6265")
public class BucketsAccessCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure granting access to %s group is safe here.";
    private static final String SECONDARY_MSG = "Related bucket";

    @Override
    protected void registerResourceChecks() {
        this.register(BucketsAccessCheck::checkBucket, "aws_s3_bucket");
    }

    private static void checkBucket(CheckContext ctx, BlockTree tree) {
        PropertyUtils.get(tree, "acl", AttributeTree.class).ifPresent(acl -> {
            if (TextUtils.matchesValue(acl.value(), s -> "public-read-write".equals(s) || "public-read".equals(s)).isTrue()) {
                ctx.reportIssue((HasTextRange)acl, String.format(MESSAGE, "AllUsers"), new SecondaryLocation(tree.labels().get(0), SECONDARY_MSG));
            } else if (TextUtils.isValue(acl.value(), "authenticated-read").isTrue()) {
                ctx.reportIssue((HasTextRange)acl, String.format(MESSAGE, "AuthenticatedUsers"), new SecondaryLocation(tree.labels().get(0), SECONDARY_MSG));
            }
        });
    }
}

