/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.exceptions.MarkedYamlEngineException;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.iac.cloudformation.checks.CloudformationCheckList;
import org.sonar.iac.cloudformation.parser.CloudformationParser;
import org.sonar.iac.cloudformation.plugin.CloudformationLanguage;
import org.sonar.iac.cloudformation.reports.CfnLintImporter;
import org.sonar.iac.cloudformation.visitors.CloudformationHighlightingVisitor;
import org.sonar.iac.cloudformation.visitors.CloudformationMetricsVisitor;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.IacSensor;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.ChecksVisitor;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonarsource.analyzer.commons.ExternalReportProvider;

public class CloudformationSensor
extends IacSensor {
    private static final String JSON_LANGUAGE_KEY = "json";
    private static final String YAML_LANGUAGE_KEY = "yaml";
    private final Checks<IacCheck> checks;

    public CloudformationSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, CloudformationLanguage language) {
        super(sonarRuntime, fileLinesContextFactory, noSonarFilter, (Language)language);
        this.checks = checkFactory.create("cloudformation");
        this.checks.addAnnotatedChecks(CloudformationCheckList.checks());
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguages(new String[]{JSON_LANGUAGE_KEY, YAML_LANGUAGE_KEY}).name("IaC " + this.language.getName() + " Sensor");
    }

    @Override
    protected TreeParser<Tree> treeParser() {
        return new CloudformationParser();
    }

    @Override
    protected String repositoryKey() {
        return "cloudformation";
    }

    @Override
    protected List<TreeVisitor<InputFileContext>> visitors(SensorContext sensorContext, DurationStatistics statistics) {
        ArrayList<TreeVisitor<InputFileContext>> visitors = new ArrayList<TreeVisitor<InputFileContext>>();
        if (this.isSonarLintContext(sensorContext)) {
            visitors.add(new CloudformationHighlightingVisitor());
            visitors.add(new CloudformationMetricsVisitor(this.fileLinesContextFactory, this.noSonarFilter));
        }
        visitors.add(new ChecksVisitor(this.checks, statistics));
        return visitors;
    }

    @Override
    protected FilePredicate mainFilePredicate(SensorContext sensorContext) {
        FileSystem fileSystem = sensorContext.fileSystem();
        return fileSystem.predicates().and(fileSystem.predicates().and(fileSystem.predicates().or(fileSystem.predicates().hasLanguage(JSON_LANGUAGE_KEY), fileSystem.predicates().hasLanguage(YAML_LANGUAGE_KEY)), fileSystem.predicates().hasType(InputFile.Type.MAIN)), (FilePredicate)new FileIdentificationPredicate(sensorContext.config().get("sonar.cloudformation.file.identifier").orElse("")));
    }

    @Override
    protected void importExternalReports(SensorContext sensorContext) {
        ExternalReportProvider.getReportFiles(sensorContext, "sonar.cloudformation.cfn-lint.reportPaths").forEach(report -> CfnLintImporter.importReport(sensorContext, report));
    }

    @Override
    protected String getActivationSettingKey() {
        return "sonar.cloudformation.activate";
    }

    @Override
    protected ParseException toParseException(String action, InputFile inputFile, Exception cause) {
        if (!(cause instanceof MarkedYamlEngineException)) {
            return super.toParseException(action, inputFile, cause);
        }
        Optional<Mark> problemMark = ((MarkedYamlEngineException)cause).getProblemMark();
        TextPointer position = null;
        if (problemMark.isPresent()) {
            position = inputFile.newPointer(problemMark.get().getLine() + 1, 0);
        }
        return new ParseException("Cannot " + action + " '" + inputFile + "': " + cause.getMessage(), position);
    }

    private static class FileIdentificationPredicate
    implements FilePredicate {
        private static final Logger LOG = Loggers.get(FileIdentificationPredicate.class);
        private final String fileIdentifier;

        public FileIdentificationPredicate(String fileIdentifier) {
            this.fileIdentifier = fileIdentifier;
        }

        public boolean apply(InputFile inputFile) {
            return this.hasFileIdentifier(inputFile);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean hasFileIdentifier(InputFile inputFile) {
            if ("".equals(this.fileIdentifier)) {
                return true;
            }
            try (Scanner scanner = new Scanner(inputFile.inputStream(), inputFile.charset().name());){
                do {
                    if (!scanner.hasNextLine()) return false;
                } while (!scanner.nextLine().contains(this.fileIdentifier));
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                LOG.error(String.format("Unable to read file: %s.", inputFile.uri()));
                LOG.error(e.getMessage());
            }
            return false;
        }
    }
}

