/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.cloudformation.api.tree.CloudformationTree;
import org.sonar.iac.cloudformation.api.tree.FileTree;
import org.sonar.iac.cloudformation.api.tree.MappingTree;
import org.sonar.iac.cloudformation.api.tree.ScalarTree;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

public abstract class AbstractResourceCheck
implements IacCheck {
    @Override
    public void initialize(InitContext init) {
        init.register(FileTree.class, (ctx, tree) -> AbstractResourceCheck.getFileResources(tree).forEach(r -> this.checkResource((CheckContext)ctx, (Resource)r)));
    }

    public static List<Resource> getFileResources(FileTree file) {
        Tree resourcesTree = PropertyUtils.valueOrNull(file.root(), "Resources");
        if (!(resourcesTree instanceof MappingTree)) {
            return Collections.emptyList();
        }
        return ((MappingTree)resourcesTree).elements().stream().filter(element -> element.key() instanceof ScalarTree && element.value() instanceof MappingTree).map(element -> Resource.fromMapping((ScalarTree)element.key(), (MappingTree)element.value())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected abstract void checkResource(CheckContext var1, Resource var2);

    static boolean isS3Bucket(Resource resource) {
        return resource.isType("AWS::S3::Bucket");
    }

    protected static void reportResource(CheckContext ctx, Resource resource, String message) {
        ctx.reportIssue(resource.type, message);
    }

    public static class Resource {
        private final ScalarTree name;
        private final CloudformationTree type;
        private final CloudformationTree properties;

        Resource(ScalarTree name, CloudformationTree type, @Nullable CloudformationTree properties) {
            this.name = name;
            this.type = type;
            this.properties = properties;
        }

        @CheckForNull
        private static Resource fromMapping(ScalarTree name, MappingTree mapping) {
            return PropertyUtils.value(mapping, "Type", CloudformationTree.class).map(typeTree -> new Resource(name, (CloudformationTree)typeTree, PropertyUtils.valueOrNull(mapping, "Properties", CloudformationTree.class))).orElse(null);
        }

        public ScalarTree name() {
            return this.name;
        }

        public CloudformationTree type() {
            return this.type;
        }

        @CheckForNull
        public CloudformationTree properties() {
            return this.properties;
        }

        public boolean isType(String expectedType) {
            return TextUtils.getValue(this.type).orElse("null").equalsIgnoreCase(expectedType);
        }
    }
}

