/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.lex;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.channel.CodeReader;
import org.sonar.channel.EndMatcher;
import org.sonar.plugins.html.lex.AbstractTokenizer;
import org.sonar.plugins.html.node.CommentNode;
import org.sonar.plugins.html.node.Node;

class CommentTokenizer<T extends List<Node>>
extends AbstractTokenizer<T> {
    private final Boolean html;
    private final char[] endChars;

    public CommentTokenizer(String startToken, String endToken, Boolean html) {
        super(startToken, endToken);
        this.html = html;
        this.endChars = endToken.toCharArray();
    }

    @Override
    protected EndMatcher getEndMatcher(CodeReader codeReader) {
        return new EndTokenMatcher(codeReader);
    }

    @Override
    Node createNode() {
        CommentNode node = new CommentNode();
        node.setHtml(this.html);
        return node;
    }

    private final class EndTokenMatcher
    implements EndMatcher {
        private final CodeReader codeReader;

        private EndTokenMatcher(CodeReader codeReader) {
            this.codeReader = codeReader;
        }

        @Override
        public boolean match(int endFlag) {
            return ArrayUtils.isEquals(this.codeReader.peek(CommentTokenizer.this.endChars.length), CommentTokenizer.this.endChars);
        }
    }
}

