/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S1451")
public class FileHeaderCheck
implements SlangCheck {
    private static final String MESSAGE = "Add or update the header of this file.";
    private static final String DEFAULT_HEADER_FORMAT = "";
    @RuleProperty(key="headerFormat", description="Expected copyright and license header", defaultValue="", type="TEXT")
    public String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    public boolean isRegularExpression = false;
    private Pattern searchPattern = null;
    private String[] expectedLines = null;
    private static final String LINES_REGEX = "\r\n|\n|\r";

    @Override
    public void initialize(InitContext init) {
        this.initializeParameters();
        init.register(TopLevelTree.class, (ctx, tree) -> {
            if (this.isRegularExpression) {
                this.checkRegularExpression((CheckContext)ctx);
            } else {
                this.checkExpectedLines((CheckContext)ctx);
            }
        });
    }

    private void initializeParameters() {
        if (this.isRegularExpression) {
            try {
                this.searchPattern = Pattern.compile(this.getHeaderFormat(), 32);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[" + this.getClass().getSimpleName() + "] Unable to compile the regular expression: " + this.headerFormat, e);
            }
        } else {
            this.expectedLines = this.headerFormat.split(LINES_REGEX);
        }
    }

    private void checkExpectedLines(CheckContext ctx) {
        String[] lines = ctx.fileContent().split(LINES_REGEX, -1);
        if (lines.length < this.expectedLines.length) {
            ctx.reportFileIssue(MESSAGE);
        } else {
            IntStream.range(0, this.expectedLines.length).filter(lineIndex -> !lines[lineIndex].equals(this.expectedLines[lineIndex])).findFirst().ifPresent(lineIndex -> ctx.reportFileIssue(MESSAGE));
        }
    }

    private void checkRegularExpression(CheckContext ctx) {
        Matcher matcher = this.searchPattern.matcher(ctx.fileContent());
        if (!matcher.find()) {
            ctx.reportFileIssue(MESSAGE);
        }
    }

    private String getHeaderFormat() {
        String format = this.headerFormat;
        if (format.charAt(0) != '^') {
            format = "^" + format;
        }
        return format;
    }
}

