/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Modifiers;
import org.sonar.flex.checks.utils.Variable;

@Rule(key="S1068")
public class UnusedPrivateFieldCheck
extends FlexCheck {
    private Deque<ClassState> classStack = new ArrayDeque<ClassState>();

    @Override
    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.CLASS_DEF, FlexGrammar.QUALIFIED_IDENTIFIER);
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        this.classStack.clear();
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.is(FlexGrammar.CLASS_DEF)) {
            this.classStack.push(new ClassState(astNode));
        } else if (!this.classStack.isEmpty() && astNode.is(FlexGrammar.QUALIFIED_IDENTIFIER)) {
            this.classStack.peek().use(astNode);
        }
    }

    @Override
    public void leaveNode(AstNode astNode) {
        if (astNode.is(FlexGrammar.CLASS_DEF)) {
            this.reportUnusedPrivateField();
        }
    }

    private void reportUnusedPrivateField() {
        for (Map.Entry entry : this.classStack.pop().privateFields.entrySet()) {
            if (((PrivateField)entry.getValue()).usages != 0) continue;
            this.addIssue(MessageFormat.format("Remove this unused ''{0}'' private field", entry.getKey()), ((PrivateField)entry.getValue()).declaration);
        }
    }

    private static class ClassState {
        private final Map<String, PrivateField> privateFields = new HashMap<String, PrivateField>();

        public ClassState(AstNode classDef) {
            this.retrieveAllPrivateFields(classDef);
        }

        private void retrieveAllPrivateFields(AstNode classDef) {
            for (AstNode varDeclaration : Clazz.getFields(classDef)) {
                if (!Modifiers.getModifiers(varDeclaration.getParent().getPreviousAstNode()).contains(FlexKeyword.PRIVATE)) continue;
                for (AstNode identifier : Variable.getDeclaredIdentifiers(varDeclaration)) {
                    this.privateFields.put(identifier.getTokenValue(), new PrivateField(identifier, 0));
                }
            }
        }

        private void use(AstNode astNode) {
            PrivateField field = this.privateFields.get(astNode.getTokenValue());
            if (field != null) {
                ++field.usages;
                return;
            }
        }
    }

    private static class PrivateField {
        final AstNode declaration;
        int usages;

        public PrivateField(AstNode declaration, int usages) {
            this.declaration = declaration;
            this.usages = usages;
        }
    }
}

