/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Variable;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends FlexCheck {
    private Scope currentScope;

    @Override
    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.FUNCTION_DEF, FlexGrammar.VARIABLE_DECLARATION_STATEMENT, FlexGrammar.QUALIFIED_IDENTIFIER);
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        this.currentScope = null;
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.is(FlexGrammar.FUNCTION_DEF)) {
            this.currentScope = new Scope(this.currentScope);
        } else if (this.currentScope != null && astNode.is(FlexGrammar.VARIABLE_DECLARATION_STATEMENT)) {
            for (AstNode varIdentifier : Variable.getDeclaredIdentifiers(astNode)) {
                this.currentScope.declare(varIdentifier);
            }
        } else if (this.currentScope != null && astNode.is(FlexGrammar.QUALIFIED_IDENTIFIER)) {
            this.currentScope.use(astNode);
        }
    }

    @Override
    public void leaveNode(AstNode astNode) {
        if (astNode.is(FlexGrammar.FUNCTION_DEF)) {
            this.reportUnusedVariable();
            this.currentScope = this.currentScope.outerScope;
        }
    }

    private void reportUnusedVariable() {
        for (Map.Entry entry : this.currentScope.variables.entrySet()) {
            if (((LocalVariable)entry.getValue()).usages != 0) continue;
            this.addIssue(MessageFormat.format("Remove this unused ''{0}'' local variable.", entry.getKey()), ((LocalVariable)entry.getValue()).declaration);
        }
    }

    private static class Scope {
        private final Scope outerScope;
        private final Map<String, LocalVariable> variables;

        public Scope(Scope outerScope) {
            this.outerScope = outerScope;
            this.variables = new HashMap<String, LocalVariable>();
        }

        private void declare(AstNode astNode) {
            String identifier = astNode.getTokenValue();
            if (!this.variables.containsKey(identifier)) {
                this.variables.put(identifier, new LocalVariable(astNode, 0));
            }
        }

        private void use(AstNode astNode) {
            String identifier = astNode.getTokenValue();
            Scope scope = this;
            while (scope != null) {
                LocalVariable var = scope.variables.get(identifier);
                if (var != null) {
                    ++var.usages;
                    return;
                }
                scope = scope.outerScope;
            }
        }
    }

    private static class LocalVariable {
        final AstNode declaration;
        int usages;

        private LocalVariable(AstNode declaration, int usages) {
            this.declaration = declaration;
            this.usages = usages;
        }
    }
}

