/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.fs.FsRepository;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public final class RepositoriesModule {
    private final RepositoriesService repositoriesService;

    public RepositoriesModule(Environment env, List<RepositoryPlugin> repoPlugins, TransportService transportService, ClusterService clusterService, BigArrays bigArrays, NamedXContentRegistry namedXContentRegistry, RecoverySettings recoverySettings) {
        HashMap<String, Repository.Factory> factories = new HashMap<String, Repository.Factory>();
        factories.put("fs", metadata -> new FsRepository(metadata, env, namedXContentRegistry, clusterService, bigArrays, recoverySettings));
        for (RepositoryPlugin repositoryPlugin : repoPlugins) {
            Map<String, Repository.Factory> newRepoTypes = repositoryPlugin.getRepositories(env, namedXContentRegistry, clusterService, bigArrays, recoverySettings);
            for (Map.Entry<String, Repository.Factory> entry : newRepoTypes.entrySet()) {
                if (factories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Repository type [" + entry.getKey() + "] is already registered");
            }
        }
        HashMap<String, Repository.Factory> internalFactories = new HashMap<String, Repository.Factory>();
        for (RepositoryPlugin repoPlugin : repoPlugins) {
            Map<String, Repository.Factory> newRepoTypes = repoPlugin.getInternalRepositories(env, namedXContentRegistry, clusterService, recoverySettings);
            for (Map.Entry<String, Repository.Factory> entry : newRepoTypes.entrySet()) {
                if (internalFactories.put(entry.getKey(), entry.getValue()) != null) {
                    throw new IllegalArgumentException("Internal repository type [" + entry.getKey() + "] is already registered");
                }
                if (factories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Internal repository type [" + entry.getKey() + "] is already registered as a non-internal repository");
            }
        }
        Settings settings = env.settings();
        Map<String, Repository.Factory> repositoryTypes = Collections.unmodifiableMap(factories);
        Map<String, Repository.Factory> internalRepositoryTypes = Collections.unmodifiableMap(internalFactories);
        this.repositoriesService = new RepositoriesService(settings, clusterService, transportService, repositoryTypes, internalRepositoryTypes, transportService.getThreadPool());
    }

    public RepositoriesService getRepositoryService() {
        return this.repositoriesService;
    }
}

